/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Dimension {
    APPLICATION("application"),
    ARCHITECTURE("architecture"),
    CLAVE("clave"),
    CLOUD("cloud"),
    CLOUD_ACCOUNT("cloud-account"),
    CLUSTER_ID("cluster-id"),
    CLUSTER_TYPE("cluster-type"),
    CONSOLE_USER_EMAIL("console-user-email"),
    ENVIRONMENT("environment"),
    HOSTNAME("hostname"),
    INSTANCE_ID("instance"),
    NODE_TYPE("node-type"),
    SYSTEM("system"),
    TENANT_ID("tenant"),
    VESPA_VERSION("vespa-version"),
    ZONE_ID("zone");

    private final String wireName;
    private static final Map<String, Dimension> dimensionsByWireName;

    public static Dimension fromWire(String wireName) {
        Dimension dimension = dimensionsByWireName.get(wireName);
        if (dimension == null) {
            throw new IllegalArgumentException("Unknown serialized dimension: '" + wireName + "'");
        }
        return dimension;
    }

    private Dimension(String wireName) {
        this.wireName = wireName;
    }

    public String toWire() {
        return this.wireName;
    }

    static {
        dimensionsByWireName = Stream.of(Dimension.values()).collect(Collectors.toMap(x -> x.wireName, Function.identity()));
    }
}

