/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.flags.custom.HostResources;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SharedHost {
    private final int DEFAULT_MIN_COUNT = 0;
    private final List<HostResources> resources;
    private final int minCount;

    public static SharedHost createDisabled() {
        return new SharedHost(null, null);
    }

    @JsonCreator
    public SharedHost(@JsonProperty(value="resources") List<HostResources> resourcesOrNull, @JsonProperty(value="min-count") Integer minCountOrNull) {
        this.resources = resourcesOrNull == null ? List.of() : List.copyOf(resourcesOrNull);
        this.minCount = this.requireNonNegative(minCountOrNull, 0, "min-count");
    }

    @JsonGetter(value="resources")
    public List<HostResources> getResourcesOrNull() {
        return this.resources.isEmpty() ? null : this.resources;
    }

    @JsonGetter(value="min-count")
    public Integer getMinCountOrNull() {
        return this.minCount == 0 ? null : Integer.valueOf(this.minCount);
    }

    @JsonIgnore
    public boolean isEnabled() {
        return this.resources.size() > 0;
    }

    @JsonIgnore
    public List<HostResources> getHostResources() {
        return this.resources;
    }

    @JsonIgnore
    public int getMinCount() {
        return this.minCount;
    }

    public String toString() {
        return this.resources.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedHost that = (SharedHost)o;
        return this.resources.equals(that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }

    private int requireNonNegative(Integer integerOrNull, int defaultValue, String fieldName) {
        if (integerOrNull == null) {
            return defaultValue;
        }
        if (integerOrNull < 0) {
            throw new IllegalArgumentException(fieldName + " cannot be negative");
        }
        return integerOrNull;
    }
}

