/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;

public class JacksonSerializer<T>
implements FlagSerializer<T> {
    private final Class<T> jacksonClass;

    public JacksonSerializer(Class<T> jacksonClass) {
        this.jacksonClass = jacksonClass;
    }

    @Override
    public T deserialize(RawFlag rawFlag) {
        return JsonNodeRawFlag.fromJsonNode(rawFlag.asJsonNode()).toJacksonClass(this.jacksonClass);
    }

    @Override
    public RawFlag serialize(T value) {
        return JsonNodeRawFlag.fromJacksonClass(value);
    }
}

