/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FlagId
implements Comparable<FlagId> {
    private static final Pattern ID_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9._-]*$");
    private final String id;

    public FlagId(String id) {
        if (!ID_PATTERN.matcher(id).find()) {
            throw new IllegalArgumentException("Not a valid FlagId: '" + id + "'");
        }
        this.id = id;
    }

    @Override
    public int compareTo(FlagId that) {
        return this.id.compareTo(that.id);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagId flagId = (FlagId)o;
        return Objects.equals(this.id, flagId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

