/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FetchVector {
    private final Map<Dimension, String> map;

    public FetchVector() {
        this.map = Collections.emptyMap();
    }

    public static FetchVector fromMap(Map<Dimension, String> map) {
        return new FetchVector(new HashMap<Dimension, String>(map));
    }

    private FetchVector(Map<Dimension, String> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public Optional<String> getValue(Dimension dimension) {
        return Optional.ofNullable(this.map.get((Object)dimension));
    }

    public Map<Dimension, String> toMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public FetchVector with(Dimension dimension, String value) {
        return this.makeFetchVector(merged -> merged.put(dimension, value));
    }

    public FetchVector with(FetchVector override) {
        return this.makeFetchVector(vector -> vector.putAll(override.map));
    }

    private FetchVector makeFetchVector(Consumer<EnumMap<Dimension, String>> mapModifier) {
        EnumMap<Dimension, String> mergedMap = new EnumMap<Dimension, String>(Dimension.class);
        mergedMap.putAll(this.map);
        mapModifier.accept(mergedMap);
        return new FetchVector(mergedMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchVector that = (FetchVector)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static enum Dimension {
        APPLICATION_ID,
        NODE_TYPE,
        CLUSTER_TYPE,
        HOSTNAME,
        VESPA_VERSION,
        ZONE_ID;

    }
}

