/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.vespa.flags.custom.PreprovisionCapacity;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundIntFlag DROP_CACHES = Flags.defineIntFlag("drop-caches", 3, "The int value to write into /proc/sys/vm/drop_caches for each tick. 1 is page cache, 2 is dentries inodes, 3 is both page cache and dentries inodes, etc.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_CROWDSTRIKE = Flags.defineFeatureFlag("enable-crowdstrike", true, "Whether to enable CrowdStrike.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_NESSUS = Flags.defineFeatureFlag("enable-nessus", true, "Whether to enable Nessus.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<String> DISABLED_HOST_ADMIN_TASKS = Flags.defineListFlag("disabled-host-admin-tasks", List.of(), String.class, "List of host-admin task names (as they appear in the log, e.g. root>main>UpgradeTask) that should be skipped", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundStringFlag DOCKER_VERSION = Flags.defineStringFlag("docker-version", "1.13.1-91.git07f3374", "The version of the docker to use of the format VERSION-REL: The YUM package to be installed will be 2:docker-VERSION-REL.el7.centos.x86_64 in AWS (and without '.centos' otherwise). If docker-version is not of this format, it must be parseable by YumPackageName::fromString.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundLongFlag THIN_POOL_GB = Flags.defineLongFlag("thin-pool-gb", -1L, "The size of the disk reserved for the thin pool with dynamic provisioning in AWS, in base-2 GB. If <0, the default is used (which may depend on the zone and node type).", "Takes effect immediately (but used only during provisioning).", FetchVector.Dimension.NODE_TYPE);
    public static final UnboundDoubleFlag CONTAINER_CPU_CAP = Flags.defineDoubleFlag("container-cpu-cap", 0.0, "Hard limit on how many CPUs a container may use. This value is multiplied by CPU allocated to node, so to cap CPU at 200%, set this to 2, etc.", "Takes effect on next node agent tick. Change is orchestrated, but does NOT require container restart", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_BUCKET_SPACE_METRIC = Flags.defineFeatureFlag("use-bucket-space-metric", true, "Whether to use vds.datastored.bucket_space.buckets_total (true) instead of vds.datastored.alldisks.buckets (false, legacy).", "Takes effect on the next deployment of the application", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag INCLUDE_SIS_IN_TRUSTSTORE = Flags.defineFeatureFlag("include-sis-in-truststore", false, "Whether to use the trust store backed by Athenz and (in public) Service Identity certificates in host-admin and/or Docker containers", "Takes effect on restart of host-admin (for host-admin), and restart of Docker container.", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag TLS_INSECURE_MIXED_MODE = Flags.defineStringFlag("tls-insecure-mixed-mode", "tls_client_mixed_server", "TLS insecure mixed mode. Allowed values: ['plaintext_client_mixed_server', 'tls_client_mixed_server', 'tls_client_tls_server']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_INSECURE_AUTHORIZATION_MODE = Flags.defineStringFlag("tls-insecure-authorization-mode", "log_only", "TLS insecure authorization mode. Allowed values: ['disable', 'log_only', 'enforce']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_ADAPTIVE_DISPATCH = Flags.defineFeatureFlag("use-adaptive-dispatch", false, "Should adaptive dispatch be used over round robin", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag REBOOT_INTERVAL_IN_DAYS = Flags.defineIntFlag("reboot-interval-in-days", 30, "No reboots are scheduled 0x-1x reboot intervals after the previous reboot, while reboot is scheduled evenly distributed in the 1x-2x range (and naturally guaranteed at the 2x boundary).", "Takes effect on next run of NodeRebooter", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag ENABLE_DYNAMIC_PROVISIONING = Flags.defineFeatureFlag("enable-dynamic-provisioning", false, "Provision a new docker host when we otherwise can't allocate a docker node", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<PreprovisionCapacity> PREPROVISION_CAPACITY = Flags.defineListFlag("preprovision-capacity", List.of(), PreprovisionCapacity.class, "List of node resources and their count that should be present in zone to receive new deployments. When a preprovisioned is taken, new will be provisioned within next iteration of maintainer.", "Takes effect on next iteration of HostProvisionMaintainer.", new FetchVector.Dimension[0]);
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, "Node resource memory in Gb for admin cluster nodes", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag HOST_HARDENING = Flags.defineFeatureFlag("host-hardening", false, "Whether to enable host hardening Linux baseline.", "Takes effect on next tick or on host-admin restart (may vary where used).", FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag ZOOKEEPER_SERVER_MAJOR_MINOR_VERSION = Flags.defineStringFlag("zookeeper-server-version", "3.5", "The version of ZooKeeper server to use (major.minor, not full version)", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_FOR_ZOOKEEPER_QUORUM_COMMUNICATION = Flags.defineStringFlag("tls-for-zookeeper-quorum-communication", "OFF", "How to setup TLS for ZooKeeper quorum communication. Valid values are OFF, PORT_UNIFICATION, TLS_WITH_PORT_UNIFICATION, TLS_ONLY", "Takes effect on restart of config server", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_FOR_ZOOKEEPER_CLIENT_SERVER_COMMUNICATION = Flags.defineStringFlag("tls-for-zookeeper-client-server-communication", "OFF", "How to setup TLS for ZooKeeper client/server communication. Valid values are OFF, PORT_UNIFICATION, TLS_WITH_PORT_UNIFICATION, TLS_ONLY", "Takes effect on restart of config server", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_TLS_FOR_ZOOKEEPER_CLIENT = Flags.defineFeatureFlag("use-tls-for-zookeeper-client", false, "Whether to use TLS for ZooKeeper clients", "Takes effect on restart of process", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_DISK_WRITE_TEST = Flags.defineFeatureFlag("enable-disk-write-test", false, "Regularly issue a small write to disk and fail the host if it is not successful", "Takes effect on next node agent tick (but does not clear existing failure reports)", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag DISABLE_CM3 = Flags.defineFeatureFlag("disable-cm3", false, "Whether to disable CM3.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_4443_UPSTREAM = Flags.defineFeatureFlag("use-4443-upstream", false, "Use port 4443 for nginx upstream", "Takes effect when routing container asks for new config", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_IN_PLACE_RESIZE = Flags.defineFeatureFlag("enable-in-place-resize", false, "Whether nodes can be resized in-place when certain conditions are met", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_CONFIG_SERVER_FOR_TESTER_API_CALLS = Flags.defineFeatureFlag("use-config-server-for-tester-api-calls", false, "Whether controller should send requests to tester API through config server (if false) or tester endpoint (if true)", "Takes effect immediately", FetchVector.Dimension.ZONE_ID);
    public static final UnboundBooleanFlag INSTALL_L4_ROUTING_SUPPORT = Flags.defineFeatureFlag("install-l4-routing-support", false, "Whether routing nodes should install package supporting L4 routing", "Takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag GENERATE_L4_ROUTING_CONFIG = Flags.defineFeatureFlag("generate-l4-routing-config", false, "Whether routing nodes should generate L4 routing config", "Takes effect immediately", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.HOSTNAME);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

