/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.json.DimensionHelper;
import com.yahoo.vespa.flags.json.wire.WireCondition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class Condition
implements Predicate<FetchVector> {
    private final Type type;
    private final FetchVector.Dimension dimension;
    private final Set<String> values;

    public Condition(Type type, FetchVector.Dimension dimension, String ... values) {
        this(type, dimension, new HashSet<String>(Arrays.asList(values)));
    }

    public Condition(Type type, FetchVector.Dimension dimension, Set<String> values) {
        this.type = type;
        this.dimension = dimension;
        this.values = values;
    }

    @Override
    public boolean test(FetchVector vector) {
        boolean isMember = vector.getValue(this.dimension).filter(this.values::contains).isPresent();
        switch (this.type) {
            case WHITELIST: {
                return isMember;
            }
            case BLACKLIST: {
                return !isMember;
            }
        }
        throw new IllegalArgumentException("Unknown type " + this.type);
    }

    public static Condition fromWire(WireCondition wireCondition) {
        Objects.requireNonNull(wireCondition.type);
        Type type = Type.valueOf(wireCondition.type.toUpperCase());
        Objects.requireNonNull(wireCondition.dimension);
        FetchVector.Dimension dimension = DimensionHelper.fromWire(wireCondition.dimension);
        Set<String> values = wireCondition.values == null ? Collections.emptySet() : wireCondition.values;
        return new Condition(type, dimension, values);
    }

    public WireCondition toWire() {
        WireCondition wire = new WireCondition();
        wire.type = this.type.name().toLowerCase();
        wire.dimension = DimensionHelper.toWire(this.dimension);
        wire.values = this.values.isEmpty() ? null : this.values;
        return wire;
    }

    public static enum Type {
        WHITELIST,
        BLACKLIST;

    }
}

