/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import java.util.function.Function;

public class LongFlag
implements Flag {
    private final FlagId id;
    private final long defaultValue;
    private final FlagSource source;

    public static Function<FlagSource, LongFlag> createUnbound(String flagId, int defaultValue) {
        return LongFlag.createUnbound(new FlagId(flagId), defaultValue);
    }

    public static Function<FlagSource, LongFlag> createUnbound(FlagId id, int defaultValue) {
        return source -> new LongFlag(id, (long)defaultValue, (FlagSource)source);
    }

    public LongFlag(String flagId, long defaultValue, FlagSource source) {
        this(new FlagId(flagId), defaultValue, source);
    }

    public LongFlag(FlagId id, long defaultValue, FlagSource source) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.source = source;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    public long value() {
        return this.source.getString(this.id).map(String::trim).map(Long::parseLong).orElse(this.defaultValue);
    }

    public String toString() {
        return "LongFlag{id=" + this.id + ", defaultValue=" + this.defaultValue + ", source=" + this.source + '}';
    }
}

