/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.io.IOUtils;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int64Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class RpcTester {
    private static final Logger log = Logger.getLogger(RpcTester.class.getName());
    private final Target target;

    private RpcTester(Target target) {
        this.target = target;
    }

    private void call(String fileReference, String filename, byte[] blob) {
        new FileReceiver(this.target).receive(new FileReference(fileReference), filename, blob);
    }

    public static void main(String[] args) {
        String fileReference = "59f93f445438c9db7ccbf1629f583c2aa004a68b";
        String filename = "com.yahoo.vespatest.ExtraHitSearcher-1.0.0-deploy.jar";
        File file = new File(String.format("/tmp/%s/%s", fileReference, filename));
        byte[] blob = null;
        try {
            blob = IOUtils.readFileBytes((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.log(Level.INFO, "Read blob from " + file.getAbsolutePath());
        Supervisor supervisor = new Supervisor(new Transport("rpctester"));
        Spec spec = new Spec("tcp/localhost:19090");
        log.log(Level.INFO, "Connecting to " + spec);
        Target target = supervisor.connect(spec);
        if (!target.isValid()) {
            log.log(Level.INFO, "Could not connect");
            System.exit(1);
        } else {
            log.log(Level.INFO, "Connected to " + spec);
        }
        new RpcTester(target).call(fileReference, filename, blob);
    }

    class FileReceiver {
        Target target;

        FileReceiver(Target target) {
            this.target = target;
        }

        void receive(FileReference reference, String filename, byte[] content) {
            log.log(Level.INFO, "Preparing receive call for " + reference.value() + " and file " + filename);
            XXHash64 hasher = XXHashFactory.fastestInstance().hash64();
            Request fileBlob = new Request("filedistribution.receiveFile");
            log.log(Level.INFO, "Calling " + fileBlob.methodName() + " with target " + this.target);
            fileBlob.parameters().add((Value)new StringValue(reference.value()));
            fileBlob.parameters().add((Value)new StringValue(filename));
            fileBlob.parameters().add((Value)new DataValue(content));
            fileBlob.parameters().add((Value)new Int64Value(hasher.hash(ByteBuffer.wrap(content), 0L)));
            fileBlob.parameters().add((Value)new Int32Value(0));
            fileBlob.parameters().add((Value)new StringValue("OK"));
            log.log(Level.INFO, "Doing invokeSync");
            this.target.invokeSync(fileBlob, 5.0);
            log.log(Level.INFO, "Done with invokeSync");
        }
    }
}

