/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.filedistribution.FileReferenceDownloader;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDownloader
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(FileDownloader.class.getName());
    public static File defaultDownloadDirectory = new File(Defaults.getDefaults().underVespaHome("var/db/vespa/filedistribution"));
    private final File downloadDirectory;
    private final Duration timeout;
    private final FileReferenceDownloader fileReferenceDownloader;

    public FileDownloader(ConnectionPool connectionPool) {
        this(connectionPool, defaultDownloadDirectory);
    }

    public FileDownloader(ConnectionPool connectionPool, File downloadDirectory) {
        this(connectionPool, downloadDirectory, downloadDirectory, Duration.ofMinutes(15L), Duration.ofSeconds(10L));
    }

    FileDownloader(ConnectionPool connectionPool, File downloadDirectory, File tmpDirectory, Duration timeout, Duration sleepBetweenRetries) {
        this.downloadDirectory = downloadDirectory;
        this.timeout = timeout;
        this.fileReferenceDownloader = new FileReferenceDownloader(downloadDirectory, tmpDirectory, connectionPool, timeout, sleepBetweenRetries);
    }

    public Optional<File> getFile(FileReference fileReference) {
        return this.getFile(new FileReferenceDownload(fileReference));
    }

    public Optional<File> getFile(FileReferenceDownload fileReferenceDownload) {
        try {
            return this.getFutureFile(fileReferenceDownload).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.log(Level.WARNING, "Failed downloading '" + fileReferenceDownload.fileReference().value() + "', removing from download queue: " + e.getMessage());
            this.fileReferenceDownloader.failedDownloading(fileReferenceDownload.fileReference());
            return Optional.empty();
        }
    }

    Future<Optional<File>> getFutureFile(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        Objects.requireNonNull(fileReference, "file reference cannot be null");
        Optional<File> file = this.getFileFromFileSystem(fileReference);
        return file.isPresent() ? CompletableFuture.completedFuture(file) : this.download(fileReferenceDownload);
    }

    double downloadStatus(FileReference fileReference) {
        return this.fileReferenceDownloader.downloadStatus(fileReference.value());
    }

    public Map<FileReference, Double> downloadStatus() {
        return this.fileReferenceDownloader.downloadStatus();
    }

    File downloadDirectory() {
        return this.downloadDirectory;
    }

    private Optional<File> getFileFromFileSystem(FileReference fileReference) {
        File[] files = new File(this.downloadDirectory, fileReference.value()).listFiles();
        if (this.downloadDirectory.exists() && this.downloadDirectory.isDirectory() && files != null && files.length > 0) {
            File file = files[0];
            if (!file.exists()) {
                throw new RuntimeException("File reference '" + fileReference.value() + "' does not exist");
            }
            if (!file.canRead()) {
                throw new RuntimeException("File reference '" + fileReference.value() + "'exists, but unable to read it");
            }
            log.log(Level.FINE, () -> "File reference '" + fileReference.value() + "' found: " + file.getAbsolutePath());
            this.fileReferenceDownloader.setDownloadStatus(fileReference, 1.0);
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private boolean alreadyDownloaded(FileReference fileReference) {
        try {
            return this.getFileFromFileSystem(fileReference).isPresent();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void downloadIfNeeded(FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        if (this.alreadyDownloaded(fileReference)) {
            return;
        }
        this.download(fileReferenceDownload);
    }

    private synchronized Future<Optional<File>> download(FileReferenceDownload fileReferenceDownload) {
        return this.fileReferenceDownloader.download(fileReferenceDownload);
    }

    public FileReferenceDownloader fileReferenceDownloader() {
        return this.fileReferenceDownloader;
    }

    @Override
    public void close() {
        this.fileReferenceDownloader.close();
    }
}

