/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.google.common.io.ByteStreams;
import com.yahoo.log.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class CompressedFileReference {
    private static final Logger log = Logger.getLogger(CompressedFileReference.class.getName());
    private static final int recurseDepth = 100;

    public static File compress(File baseDir, List<File> inputFiles, File outputFile) throws IOException {
        TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(outputFile)));
        archiveOutputStream.setLongFileMode(3);
        CompressedFileReference.createArchiveFile((ArchiveOutputStream)archiveOutputStream, baseDir, inputFiles);
        return outputFile;
    }

    public static File compress(File directory, File outputFile) throws IOException {
        return CompressedFileReference.compress(directory, Files.find(Paths.get(directory.getAbsolutePath(), new String[0]), 100, (p, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]).map(Path::toFile).collect(Collectors.toList()), outputFile);
    }

    public static byte[] compress(File directory) throws IOException {
        return CompressedFileReference.compress(directory, Files.find(Paths.get(directory.getAbsolutePath(), new String[0]), 100, (p, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]).map(Path::toFile).collect(Collectors.toList()));
    }

    public static byte[] compress(File baseDir, List<File> inputFiles) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(out));
        archiveOutputStream.setLongFileMode(3);
        CompressedFileReference.createArchiveFile((ArchiveOutputStream)archiveOutputStream, baseDir, inputFiles);
        return out.toByteArray();
    }

    static void decompress(File inputFile, File outputDir) throws IOException {
        log.log((Level)LogLevel.DEBUG, () -> "Decompressing '" + inputFile + "' into '" + outputDir + "'");
        try (TarArchiveInputStream ais = new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(inputFile)));){
            CompressedFileReference.decompress((ArchiveInputStream)ais, outputDir);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to decompress '" + inputFile.getAbsolutePath() + "': " + e.getMessage());
        }
    }

    private static void decompress(ArchiveInputStream archiveInputStream, File outputFile) throws IOException {
        ArchiveEntry entry;
        int entries = 0;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            log.log((Level)LogLevel.DEBUG, "Unpacking " + entry.getName());
            File outFile = new File(outputFile, entry.getName());
            if (entry.isDirectory()) {
                if (!outFile.exists() || !outFile.isDirectory()) {
                    log.log((Level)LogLevel.DEBUG, () -> "Creating dir: " + outFile.getAbsolutePath());
                    if (!outFile.mkdirs()) {
                        log.log(LogLevel.WARNING, "Could not create dir " + entry.getName());
                    }
                }
            } else {
                File parent = new File(outFile.getParent());
                if (!parent.exists() && !parent.mkdirs()) {
                    log.log(LogLevel.WARNING, "Could not create dir " + parent.getAbsolutePath());
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                ByteStreams.copy((InputStream)archiveInputStream, (OutputStream)fos);
                fos.close();
            }
            ++entries;
        }
        if (entries == 0) {
            throw new IllegalArgumentException("Not able to read any entries from stream (" + archiveInputStream.getBytesRead() + " bytes read from stream)");
        }
    }

    private static void createArchiveFile(ArchiveOutputStream archiveOutputStream, File baseDir, List<File> inputFiles) throws IOException {
        inputFiles.forEach(file -> {
            try {
                CompressedFileReference.writeFileToTar(archiveOutputStream, baseDir, file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        archiveOutputStream.close();
    }

    private static void writeFileToTar(ArchiveOutputStream taos, File baseDir, File file) throws IOException {
        log.log((Level)LogLevel.DEBUG, () -> "Adding file to tar: " + baseDir.toPath().relativize(file.toPath()).toString());
        taos.putArchiveEntry(taos.createArchiveEntry(file, baseDir.toPath().relativize(file.toPath()).toString()));
        ByteStreams.copy((InputStream)new FileInputStream(file), (OutputStream)taos);
        taos.closeArchiveEntry();
    }
}

