/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import java.nio.ByteBuffer;

public abstract class FileReferenceData {
    private final FileReference fileReference;
    private final String filename;
    private final Type type;

    public FileReferenceData(FileReference fileReference, String filename, Type type) {
        this.fileReference = fileReference;
        this.filename = filename;
        this.type = type;
    }

    public FileReference fileReference() {
        return this.fileReference;
    }

    public String filename() {
        return this.filename;
    }

    public Type type() {
        return this.type;
    }

    public ByteBuffer content() {
        ByteBuffer bb = ByteBuffer.allocate((int)this.size());
        while (bb.remaining() > 0) {
            this.nextContent(bb);
        }
        return bb;
    }

    public abstract int nextContent(ByteBuffer var1);

    public abstract long xxhash();

    public abstract long size();

    public abstract void close();

    public static enum Type {
        file,
        compressed;

    }
}

