/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.filedistribution.FileReceiver;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileReferenceDownloader {
    private static final Logger log = Logger.getLogger(FileReferenceDownloader.class.getName());
    private static final Duration rpcTimeout = Duration.ofMinutes(10L);
    private final ExecutorService downloadExecutor = Executors.newFixedThreadPool(10, (ThreadFactory)new DaemonThreadFactory("filereference downloader"));
    private final ConnectionPool connectionPool;
    private final Map<FileReference, FileReferenceDownload> downloads = new LinkedHashMap<FileReference, FileReferenceDownload>();
    private final Map<FileReference, Double> downloadStatus = new HashMap<FileReference, Double>();
    private final Duration downloadTimeout;
    private final FileReceiver fileReceiver;

    FileReferenceDownloader(File downloadDirectory, File tmpDirectory, ConnectionPool connectionPool, Duration timeout) {
        this.connectionPool = connectionPool;
        this.downloadTimeout = timeout;
        this.fileReceiver = new FileReceiver(connectionPool.getSupervisor(), this, downloadDirectory, tmpDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDownload(Duration timeout, FileReferenceDownload fileReferenceDownload) {
        FileReference fileReference = fileReferenceDownload.fileReference();
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            this.downloads.put(fileReference, fileReferenceDownload);
            this.downloadStatus.put(fileReference, 0.0);
        }
        long end = System.currentTimeMillis() + timeout.toMillis();
        boolean downloadStarted = false;
        while (System.currentTimeMillis() < end && !downloadStarted) {
            try {
                if (this.startDownloadRpc(fileReference)) {
                    downloadStarted = true;
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!downloadStarted) {
            fileReferenceDownload.future().setException((Throwable)new RuntimeException("Failed getting file reference '" + fileReference.value() + "'"));
            Map<FileReference, FileReferenceDownload> map2 = this.downloads;
            synchronized (map2) {
                this.downloads.remove(fileReference);
            }
        }
    }

    void addToDownloadQueue(FileReferenceDownload fileReferenceDownload) {
        log.log((Level)LogLevel.DEBUG, "Will download file reference '" + fileReferenceDownload.fileReference().value() + "' with timeout " + this.downloadTimeout);
        this.downloadExecutor.submit(() -> this.startDownload(this.downloadTimeout, fileReferenceDownload));
    }

    void receiveFile(FileReferenceData fileReferenceData) {
        this.fileReceiver.receiveFile(fileReferenceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completedDownloading(FileReference fileReference, File file) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            FileReferenceDownload download = this.downloads.get(fileReference);
            if (download != null) {
                this.downloadStatus.put(fileReference, 1.0);
                this.downloads.remove(fileReference);
                download.future().set(Optional.of(file));
            } else {
                log.log(LogLevel.INFO, "Received '" + fileReference + "', which was not requested. Can be ignored if happening during upgrades/restarts");
            }
        }
    }

    private boolean startDownloadRpc(FileReference fileReference) {
        Connection connection = this.connectionPool.getCurrent();
        Request request = new Request("filedistribution.serveFile");
        request.parameters().add((Value)new StringValue(fileReference.value()));
        this.execute(request, connection);
        if (this.validateResponse(request)) {
            log.log((Level)LogLevel.DEBUG, "Request callback, OK. Req: " + request + "\nSpec: " + connection);
            if (request.returnValues().get(0).asInt32() == 0) {
                log.log((Level)LogLevel.DEBUG, "Found file reference '" + fileReference.value() + "' available at " + connection.getAddress());
                return true;
            }
            log.log(LogLevel.INFO, "File reference '" + fileReference.value() + "' not found for " + connection.getAddress());
            this.connectionPool.setNewCurrentConnection();
            return false;
        }
        log.log(LogLevel.WARNING, "Request failed. Req: " + request + "\nSpec: " + connection.getAddress() + ", error code: " + request.errorCode());
        if (request.isError() && request.errorCode() == 104 || request.errorCode() == 103) {
            log.log(LogLevel.WARNING, "Setting error for connection " + connection.getAddress());
            this.connectionPool.setError(connection, request.errorCode());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDownloading(FileReference fileReference) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            return this.downloads.containsKey(fileReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Optional<File>> addDownloadListener(FileReference fileReference, Runnable runnable) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            FileReferenceDownload download = this.downloads.get(fileReference);
            if (download != null) {
                download.future().addListener(runnable, (Executor)this.downloadExecutor);
                return download.future();
            }
        }
        return null;
    }

    private void execute(Request request, Connection connection) {
        connection.invokeSync(request, (double)rpcTimeout.getSeconds());
    }

    private boolean validateResponse(Request request) {
        if (request.isError()) {
            return false;
        }
        if (request.returnValues().size() == 0) {
            return false;
        }
        if (!request.checkReturnTypes("is")) {
            log.log(LogLevel.WARNING, "Invalid return types for response: " + request.errorMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double downloadStatus(String file) {
        double status = 0.0;
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            Double download = this.downloadStatus.get(new FileReference(file));
            if (download != null) {
                status = download;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDownloadStatus(FileReference fileReference, double completeness) {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            this.downloadStatus.put(fileReference, completeness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<FileReference, Double> downloadStatus() {
        Map<FileReference, FileReferenceDownload> map = this.downloads;
        synchronized (map) {
            return ImmutableMap.copyOf(this.downloadStatus);
        }
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }
}

