/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.jrt.DoubleArray;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.filedistribution.FileDownloader;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileDistributionRpcServer {
    private static final Logger log = Logger.getLogger(FileDistributionRpcServer.class.getName());
    private final Supervisor supervisor;
    private final FileDownloader downloader;
    private static final int baseErrorCode = 65536;
    private static final int baseFileProviderErrorCode = 69632;
    private static final int fileReferenceDoesNotExists = 69632;
    private static final int fileReferenceRemoved = 69633;
    private static final int fileReferenceInternalError = 69634;

    public FileDistributionRpcServer(Supervisor supervisor, FileDownloader downloader) {
        this.supervisor = supervisor;
        this.downloader = downloader;
        this.declareFileDistributionMethods();
    }

    private void declareFileDistributionMethods() {
        this.supervisor.addMethod(new Method("waitFor", "s", "s", (Object)this, "getFile").methodDesc("get path to file reference").paramDesc(0, "file reference", "file reference").returnDesc(0, "path", "path to file"));
        this.supervisor.addMethod(new Method("filedistribution.getFile", "s", "s", (Object)this, "getFile").methodDesc("get path to file reference").paramDesc(0, "file reference", "file reference").returnDesc(0, "path", "path to file"));
        this.supervisor.addMethod(new Method("filedistribution.getActiveFileReferencesStatus", "", "SD", (Object)this, "getActiveFileReferencesStatus").methodDesc("download status for file references").returnDesc(0, "file references", "array of file references").returnDesc(1, "download status", "percentage downloaded of each file reference in above array"));
        this.supervisor.addMethod(new Method("filedistribution.setFileReferencesToDownload", "S", "i", (Object)this, "setFileReferencesToDownload").methodDesc("set which file references to download").paramDesc(0, "file references", "file reference to download").returnDesc(0, "ret", "0 if success, 1 otherwise"));
    }

    public final void getFile(Request req) {
        req.detach();
        FileReference fileReference = new FileReference(req.parameters().get(0).asString());
        log.log((Level)LogLevel.DEBUG, "getFile() called for file reference '" + fileReference.value() + "'");
        Optional<File> pathToFile = this.downloader.getFile(fileReference);
        try {
            if (pathToFile.isPresent()) {
                req.returnValues().add((Value)new StringValue(pathToFile.get().getAbsolutePath()));
                log.log(LogLevel.INFO, "File reference '" + fileReference.value() + "' available at " + pathToFile.get());
            } else {
                log.log(LogLevel.INFO, "File reference '" + fileReference.value() + "' not found, returning error");
                req.setError(69632, "File reference '" + fileReference.value() + "' not found");
            }
        }
        catch (Throwable e) {
            log.log(LogLevel.WARNING, "File reference '" + fileReference.value() + "' got exeption: " + e.getMessage());
            req.setError(69634, "File reference '" + fileReference.value() + "' removed");
        }
        req.returnRequest();
    }

    public final void getActiveFileReferencesStatus(Request req) {
        Map<FileReference, Double> downloadStatus = this.downloader.downloadStatus();
        String[] fileRefArray = new String[downloadStatus.keySet().size()];
        fileRefArray = downloadStatus.keySet().stream().map(FileReference::value).collect(Collectors.toList()).toArray(fileRefArray);
        double[] downloadStatusArray = new double[downloadStatus.values().size()];
        int i = 0;
        for (Double d : downloadStatus.values()) {
            downloadStatusArray[i++] = d;
        }
        req.returnValues().add((Value)new StringArray(fileRefArray));
        req.returnValues().add((Value)new DoubleArray(downloadStatusArray));
    }

    public final void setFileReferencesToDownload(Request req) {
        String[] fileReferenceStrings = req.parameters().get(0).asStringArray();
        List<FileReference> fileReferences = Stream.of(fileReferenceStrings).map(FileReference::new).collect(Collectors.toList());
        this.downloader.queueForAsyncDownload(fileReferences);
        req.returnValues().add((Value)new Int32Value(0));
    }
}

