/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.document.select.BucketSelector;
import com.yahoo.document.select.BucketSet;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import java.util.Iterator;

public class RemoveLocationMessage
extends DocumentMessage {
    String documentSelection;
    BucketId bucketId;
    private final String bucketSpace;

    public RemoveLocationMessage(String documentSelection, String bucketSpace) {
        this.bucketSpace = bucketSpace;
        try {
            this.documentSelection = documentSelection;
            BucketSelector bucketSel = new BucketSelector(new BucketIdFactory());
            BucketSet rawBuckets = bucketSel.getBucketList(documentSelection);
            if (rawBuckets == null || rawBuckets.size() != 1) {
                throw new IllegalArgumentException("Document selection for remove location must map to a single location (user or group)");
            }
            Iterator iterator = rawBuckets.iterator();
            while (iterator.hasNext()) {
                BucketId id;
                this.bucketId = id = (BucketId)iterator.next();
            }
        }
        catch (ParseException p) {
            throw new IllegalArgumentException(p);
        }
    }

    public RemoveLocationMessage(String documentSelection) {
        this(documentSelection, FixedBucketSpaces.defaultSpace());
    }

    public String getDocumentSelection() {
        return this.documentSelection;
    }

    @Override
    public DocumentReply createReply() {
        return new DocumentReply(200024);
    }

    public int getType() {
        return 100024;
    }

    public BucketId getBucketId() {
        return this.bucketId;
    }

    public String getBucketSpace() {
        return this.bucketSpace;
    }
}

