/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import ai.vespa.documentapi.protobuf.DocapiCommon;
import ai.vespa.documentapi.protobuf.DocapiFeed;
import ai.vespa.documentapi.protobuf.DocapiInspect;
import ai.vespa.documentapi.protobuf.DocapiVisiting;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Parser;
import com.yahoo.document.BucketId;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.GlobalId;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentDeserializerFactory;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorReply;
import com.yahoo.documentapi.messagebus.protocol.DestroyVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentIgnoredReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentListEntry;
import com.yahoo.documentapi.messagebus.protocol.DocumentListMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentState;
import com.yahoo.documentapi.messagebus.protocol.EmptyBucketsMessage;
import com.yahoo.documentapi.messagebus.protocol.GetBucketListMessage;
import com.yahoo.documentapi.messagebus.protocol.GetBucketListReply;
import com.yahoo.documentapi.messagebus.protocol.GetBucketStateMessage;
import com.yahoo.documentapi.messagebus.protocol.GetBucketStateReply;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.MapVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.QueryResultMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.RemoveLocationMessage;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactory;
import com.yahoo.documentapi.messagebus.protocol.StatBucketMessage;
import com.yahoo.documentapi.messagebus.protocol.StatBucketReply;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.VisitorInfoMessage;
import com.yahoo.documentapi.messagebus.protocol.VisitorReply;
import com.yahoo.documentapi.messagebus.protocol.WriteDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.WrongDistributionReply;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.messagebus.Routable;
import com.yahoo.vdslib.DocumentSummary;
import com.yahoo.vdslib.SearchResult;
import com.yahoo.vdslib.VisitorStatistics;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class RoutableFactories80 {
    private static final Logger log = Logger.getLogger(RoutableFactories80.class.getName());

    RoutableFactories80() {
    }

    private static DocapiCommon.GlobalId toProtoGlobalId(GlobalId gid) {
        return DocapiCommon.GlobalId.newBuilder().setRawGid(ByteString.copyFrom((byte[])gid.getRawId())).build();
    }

    private static GlobalId fromProtoGlobalId(DocapiCommon.GlobalId gid) {
        return new GlobalId(gid.getRawGid().toByteArray());
    }

    private static DocapiCommon.BucketId toProtoBucketId(BucketId id) {
        return DocapiCommon.BucketId.newBuilder().setRawId(id.getRawId()).build();
    }

    private static BucketId fromProtoBucketId(DocapiCommon.BucketId id) {
        return new BucketId(id.getRawId());
    }

    private static DocapiCommon.DocumentId toProtoDocId(DocumentId id) {
        return DocapiCommon.DocumentId.newBuilder().setId(id.toString()).build();
    }

    private static DocumentId fromProtoDocId(DocapiCommon.DocumentId id) {
        return new DocumentId(id.getId());
    }

    private static DocapiCommon.FieldSet toProtoFieldSet(String rawFieldSpec) {
        return DocapiCommon.FieldSet.newBuilder().setSpec(rawFieldSpec).build();
    }

    private static String fromProtoFieldSet(DocapiCommon.FieldSet fieldSet) {
        return fieldSet.getSpec();
    }

    private static ByteBuffer serializeDoc(Document doc) {
        GrowableByteBuffer buf = new GrowableByteBuffer(8192, 2.0f);
        doc.serialize((DocumentWriter)DocumentSerializerFactory.createHead((GrowableByteBuffer)buf));
        buf.flip();
        return buf.getByteBuffer();
    }

    private static DocapiCommon.Document toProtoDocument(Document doc) {
        return RoutableFactories80.toProtoDocument(RoutableFactories80.serializeDoc(doc));
    }

    private static DocapiCommon.Document toProtoDocument(ByteBuffer rawDocData) {
        return DocapiCommon.Document.newBuilder().setPayload(ByteString.copyFrom((ByteBuffer)rawDocData)).build();
    }

    private static Document fromProtoDocument(DocapiCommon.Document protoDoc, DocumentTypeManager repo) {
        DocumentDeserializer deserializer = DocumentDeserializerFactory.createHead((DocumentTypeManager)repo, (GrowableByteBuffer)new GrowableByteBuffer(protoDoc.getPayload().asReadOnlyByteBuffer()));
        return Document.createDocument((DocumentReader)deserializer);
    }

    private static Document deserializeDoc(ByteBuffer rawDocData, DocumentTypeManager repo) {
        DocumentDeserializer deserializer = DocumentDeserializerFactory.createHead((DocumentTypeManager)repo, (GrowableByteBuffer)new GrowableByteBuffer(rawDocData));
        return Document.createDocument((DocumentReader)deserializer);
    }

    private static DocapiFeed.TestAndSetCondition toProtoTasCondition(TestAndSetCondition tasCond) {
        DocapiFeed.TestAndSetCondition.Builder builder = DocapiFeed.TestAndSetCondition.newBuilder();
        if (!tasCond.getSelection().isEmpty()) {
            builder.setSelection(tasCond.getSelection());
        }
        if (tasCond.requiredTimestamp() != 0L) {
            builder.setRequiredTimestamp(tasCond.requiredTimestamp());
        }
        return builder.build();
    }

    private static TestAndSetCondition fromProtoTasCondition(DocapiFeed.TestAndSetCondition protoTasCond) {
        if (!protoTasCond.getSelection().isEmpty()) {
            if (protoTasCond.getRequiredTimestamp() != 0L) {
                return TestAndSetCondition.ofRequiredTimestampWithSelectionFallback((long)protoTasCond.getRequiredTimestamp(), (String)protoTasCond.getSelection());
            }
            return new TestAndSetCondition(protoTasCond.getSelection());
        }
        if (protoTasCond.getRequiredTimestamp() != 0L) {
            return TestAndSetCondition.ofRequiredTimestamp((long)protoTasCond.getRequiredTimestamp());
        }
        return TestAndSetCondition.NOT_PRESENT_CONDITION;
    }

    private static ByteBuffer serializeUpdate(DocumentUpdate update) {
        GrowableByteBuffer buf = new GrowableByteBuffer(4096, 2.0f);
        update.serialize((DocumentUpdateWriter)DocumentSerializerFactory.createHead((GrowableByteBuffer)buf));
        buf.flip();
        return buf.getByteBuffer();
    }

    private static DocapiFeed.DocumentUpdate toProtoUpdate(DocumentUpdate update) {
        return DocapiFeed.DocumentUpdate.newBuilder().setPayload(ByteString.copyFrom((ByteBuffer)RoutableFactories80.serializeUpdate(update))).build();
    }

    private static DocumentUpdate fromProtoUpdate(DocapiFeed.DocumentUpdate protoUpdate, DocumentTypeManager repo) {
        DocumentDeserializer deserializer = DocumentDeserializerFactory.createHead((DocumentTypeManager)repo, (GrowableByteBuffer)new GrowableByteBuffer(protoUpdate.getPayload().asReadOnlyByteBuffer()));
        return new DocumentUpdate((DocumentUpdateReader)deserializer);
    }

    private static DocapiCommon.DocumentSelection toProtoDocumentSelection(String rawSelection) {
        return DocapiCommon.DocumentSelection.newBuilder().setSelection(rawSelection).build();
    }

    private static String fromProtoDocumentSelection(DocapiCommon.DocumentSelection protoSelection) {
        return protoSelection.getSelection();
    }

    private static DocapiCommon.BucketSpace toProtoBucketSpace(String spaceName) {
        return DocapiCommon.BucketSpace.newBuilder().setName(spaceName).build();
    }

    private static String fromProtoBucketSpace(DocapiCommon.BucketSpace protoSpace) {
        return protoSpace.getName();
    }

    private static DocapiCommon.ClusterState toProtoClusterState(String stateStr) {
        return DocapiCommon.ClusterState.newBuilder().setStateString(stateStr).build();
    }

    private static String fromProtoClusterState(DocapiCommon.ClusterState state) {
        return state.getStateString();
    }

    static RoutableFactory createGetDocumentMessageFactory() {
        return ProtobufCodecBuilder.of(GetDocumentMessage.class, DocapiFeed.GetDocumentRequest.class).encoder(apiMsg -> {
            DocapiFeed.GetDocumentRequest.Builder builder = DocapiFeed.GetDocumentRequest.newBuilder().setDocumentId(RoutableFactories80.toProtoDocId(apiMsg.getDocumentId())).setFieldSet(RoutableFactories80.toProtoFieldSet(apiMsg.getFieldSet()));
            if (apiMsg.hasDebugReplicaNodeId()) {
                builder.setDebugReplicaNodeId(apiMsg.getDebugReplicaNodeId());
            }
            return builder.build();
        }).decoder(DocapiFeed.GetDocumentRequest.parser(), protoMsg -> {
            GetDocumentMessage msg = new GetDocumentMessage(RoutableFactories80.fromProtoDocId(protoMsg.getDocumentId()), RoutableFactories80.fromProtoFieldSet(protoMsg.getFieldSet()));
            if (protoMsg.hasDebugReplicaNodeId()) {
                msg.setDebugReplicaNodeId(protoMsg.getDebugReplicaNodeId());
            }
            return msg;
        }).build();
    }

    static RoutableFactory createGetDocumentReplyFactory() {
        return ProtobufCodecBuilder.of(GetDocumentReply.class, DocapiFeed.GetDocumentResponse.class).encoder(apiReply -> {
            DocapiFeed.GetDocumentResponse.Builder builder = DocapiFeed.GetDocumentResponse.newBuilder().setLastModified(apiReply.getLastModified());
            Document maybeDoc = apiReply.getDocument();
            if (maybeDoc != null) {
                builder.setDocument(RoutableFactories80.toProtoDocument(RoutableFactories80.serializeDoc(maybeDoc)));
            }
            return builder.build();
        }).decoderWithRepo(DocapiFeed.GetDocumentResponse.parser(), (protoReply, repo) -> {
            GetDocumentReply reply;
            if (protoReply.hasDocument()) {
                Document doc = RoutableFactories80.fromProtoDocument(protoReply.getDocument(), repo);
                doc.setLastModified(Long.valueOf(protoReply.getLastModified()));
                reply = new GetDocumentReply(doc);
            } else {
                reply = new GetDocumentReply(null);
            }
            reply.setLastModified(protoReply.getLastModified());
            return reply;
        }).build();
    }

    static RoutableFactory createPutDocumentMessageFactory() {
        return ProtobufCodecBuilder.of(PutDocumentMessage.class, DocapiFeed.PutDocumentRequest.class).encoder(apiMsg -> {
            DocapiFeed.PutDocumentRequest.Builder builder = DocapiFeed.PutDocumentRequest.newBuilder().setForceAssignTimestamp(apiMsg.getTimestamp()).setPersistedTimestamp(apiMsg.getPersistedTimestamp()).setCreateIfMissing(apiMsg.getCreateIfNonExistent()).setDocument(RoutableFactories80.toProtoDocument(apiMsg.getDocumentPut().getDocument()));
            if (apiMsg.getCondition().isPresent()) {
                builder.setCondition(RoutableFactories80.toProtoTasCondition(apiMsg.getCondition()));
            }
            return builder.build();
        }).decoderWithRepo(DocapiFeed.PutDocumentRequest.parser(), (protoMsg, repo) -> {
            Document doc = RoutableFactories80.fromProtoDocument(protoMsg.getDocument(), repo);
            PutDocumentMessage msg = new PutDocumentMessage(new DocumentPut(doc));
            if (protoMsg.hasCondition()) {
                msg.setCondition(RoutableFactories80.fromProtoTasCondition(protoMsg.getCondition()));
            }
            msg.setTimestamp(protoMsg.getForceAssignTimestamp());
            msg.setPersistedTimestamp(protoMsg.getPersistedTimestamp());
            msg.setCreateIfNonExistent(protoMsg.getCreateIfMissing());
            return msg;
        }).build();
    }

    static RoutableFactory createPutDocumentReplyFactory() {
        return ProtobufCodecBuilder.of(WriteDocumentReply.class, DocapiFeed.PutDocumentResponse.class).encoder(apiReply -> DocapiFeed.PutDocumentResponse.newBuilder().setModificationTimestamp(apiReply.getHighestModificationTimestamp()).build()).decoder(DocapiFeed.PutDocumentResponse.parser(), protoReply -> {
            WriteDocumentReply reply = new WriteDocumentReply(200004);
            reply.setHighestModificationTimestamp(protoReply.getModificationTimestamp());
            return reply;
        }).build();
    }

    static RoutableFactory createUpdateDocumentMessageFactory() {
        return ProtobufCodecBuilder.of(UpdateDocumentMessage.class, DocapiFeed.UpdateDocumentRequest.class).encoder(apiMsg -> {
            DocapiFeed.UpdateDocumentRequest.Builder builder = DocapiFeed.UpdateDocumentRequest.newBuilder().setUpdate(RoutableFactories80.toProtoUpdate(apiMsg.getDocumentUpdate())).setExpectedOldTimestamp(apiMsg.getOldTimestamp()).setForceAssignTimestamp(apiMsg.getNewTimestamp());
            if (apiMsg.getCondition().isPresent()) {
                builder.setCondition(RoutableFactories80.toProtoTasCondition(apiMsg.getCondition()));
            }
            builder.setCreateIfMissing(apiMsg.createIfMissing() ? DocapiFeed.UpdateDocumentRequest.CreateIfMissing.TRUE : DocapiFeed.UpdateDocumentRequest.CreateIfMissing.FALSE);
            return builder.build();
        }).decoderWithRepo(DocapiFeed.UpdateDocumentRequest.parser(), (protoMsg, repo) -> {
            UpdateDocumentMessage msg = new UpdateDocumentMessage(RoutableFactories80.fromProtoUpdate(protoMsg.getUpdate(), repo));
            msg.setOldTimestamp(protoMsg.getExpectedOldTimestamp());
            msg.setNewTimestamp(protoMsg.getForceAssignTimestamp());
            if (protoMsg.hasCondition()) {
                msg.setCondition(RoutableFactories80.fromProtoTasCondition(protoMsg.getCondition()));
            }
            return msg;
        }).build();
    }

    static RoutableFactory createUpdateDocumentReplyFactory() {
        return ProtobufCodecBuilder.of(UpdateDocumentReply.class, DocapiFeed.UpdateDocumentResponse.class).encoder(apiReply -> DocapiFeed.UpdateDocumentResponse.newBuilder().setModificationTimestamp(apiReply.getHighestModificationTimestamp()).setWasFound(apiReply.wasFound()).build()).decoder(DocapiFeed.UpdateDocumentResponse.parser(), protoReply -> {
            UpdateDocumentReply reply = new UpdateDocumentReply();
            reply.setHighestModificationTimestamp(protoReply.getModificationTimestamp());
            reply.setWasFound(protoReply.getWasFound());
            return reply;
        }).build();
    }

    static RoutableFactory createRemoveDocumentMessageFactory() {
        return ProtobufCodecBuilder.of(RemoveDocumentMessage.class, DocapiFeed.RemoveDocumentRequest.class).encoder(apiMsg -> {
            DocapiFeed.RemoveDocumentRequest.Builder builder = DocapiFeed.RemoveDocumentRequest.newBuilder().setDocumentId(RoutableFactories80.toProtoDocId(apiMsg.getDocumentId())).setPersistedTimestamp(apiMsg.getPersistedTimestamp());
            if (apiMsg.getCondition().isPresent()) {
                builder.setCondition(RoutableFactories80.toProtoTasCondition(apiMsg.getCondition()));
            }
            return builder.build();
        }).decoder(DocapiFeed.RemoveDocumentRequest.parser(), protoMsg -> {
            RemoveDocumentMessage msg = new RemoveDocumentMessage(RoutableFactories80.fromProtoDocId(protoMsg.getDocumentId()));
            if (protoMsg.hasCondition()) {
                msg.setCondition(RoutableFactories80.fromProtoTasCondition(protoMsg.getCondition()));
            }
            msg.setPersistedTimestamp(protoMsg.getPersistedTimestamp());
            return msg;
        }).build();
    }

    static RoutableFactory createRemoveDocumentReplyFactory() {
        return ProtobufCodecBuilder.of(RemoveDocumentReply.class, DocapiFeed.RemoveDocumentResponse.class).encoder(apiReply -> DocapiFeed.RemoveDocumentResponse.newBuilder().setWasFound(apiReply.wasFound()).setModificationTimestamp(apiReply.getHighestModificationTimestamp()).build()).decoder(DocapiFeed.RemoveDocumentResponse.parser(), protoReply -> {
            RemoveDocumentReply reply = new RemoveDocumentReply();
            reply.setWasFound(protoReply.getWasFound());
            reply.setHighestModificationTimestamp(protoReply.getModificationTimestamp());
            return reply;
        }).build();
    }

    static RoutableFactory createRemoveLocationMessageFactory() {
        return ProtobufCodecBuilder.of(RemoveLocationMessage.class, DocapiFeed.RemoveLocationRequest.class).encoder(apiMsg -> DocapiFeed.RemoveLocationRequest.newBuilder().setBucketSpace(RoutableFactories80.toProtoBucketSpace(apiMsg.getBucketSpace())).setSelection(RoutableFactories80.toProtoDocumentSelection(apiMsg.getDocumentSelection())).build()).decoder(DocapiFeed.RemoveLocationRequest.parser(), protoMsg -> new RemoveLocationMessage(RoutableFactories80.fromProtoDocumentSelection(protoMsg.getSelection()), RoutableFactories80.fromProtoBucketSpace(protoMsg.getBucketSpace()))).build();
    }

    static RoutableFactory createRemoveLocationReplyFactory() {
        return ProtobufCodecBuilder.of(DocumentReply.class, DocapiFeed.RemoveLocationResponse.class).encoder(apiReply -> DocapiFeed.RemoveLocationResponse.newBuilder().build()).decoder(DocapiFeed.RemoveLocationResponse.parser(), protoReply -> new DocumentReply(200024)).build();
    }

    private static DocapiVisiting.VisitorParameter toProtoVisitorParameter(String key, byte[] value) {
        return DocapiVisiting.VisitorParameter.newBuilder().setKey(key).setValue(ByteString.copyFrom((byte[])value)).build();
    }

    static RoutableFactory createCreateVisitorMessageFactory() {
        return ProtobufCodecBuilder.of(CreateVisitorMessage.class, DocapiVisiting.CreateVisitorRequest.class).encoder(apiMsg -> {
            DocapiVisiting.CreateVisitorRequest.Builder builder = DocapiVisiting.CreateVisitorRequest.newBuilder().setBucketSpace(RoutableFactories80.toProtoBucketSpace(apiMsg.getBucketSpace())).setVisitorLibraryName(apiMsg.getLibraryName()).setInstanceId(apiMsg.getInstanceId()).setControlDestination(apiMsg.getControlDestination()).setDataDestination(apiMsg.getDataDestination()).setSelection(RoutableFactories80.toProtoDocumentSelection(apiMsg.getDocumentSelection())).setFieldSet(RoutableFactories80.toProtoFieldSet(apiMsg.getFieldSet())).setMaxPendingReplyCount(apiMsg.getMaxPendingReplyCount()).setFromTimestamp(apiMsg.getFromTimestamp()).setToTimestamp(apiMsg.getToTimestamp()).setVisitTombstones(apiMsg.getVisitRemoves()).setVisitInconsistentBuckets(apiMsg.getVisitInconsistentBuckets()).setMaxBucketsPerVisitor(apiMsg.getMaxBucketsPerVisitor());
            for (BucketId bucketId : apiMsg.getBuckets()) {
                builder.addBuckets(RoutableFactories80.toProtoBucketId(bucketId));
            }
            for (Map.Entry entry : apiMsg.getParameters().entrySet()) {
                builder.addParameters(RoutableFactories80.toProtoVisitorParameter((String)entry.getKey(), (byte[])entry.getValue()));
            }
            return builder.build();
        }).decoder(DocapiVisiting.CreateVisitorRequest.parser(), protoMsg -> {
            CreateVisitorMessage msg = new CreateVisitorMessage();
            msg.setBucketSpace(RoutableFactories80.fromProtoBucketSpace(protoMsg.getBucketSpace()));
            msg.setLibraryName(protoMsg.getVisitorLibraryName());
            msg.setInstanceId(protoMsg.getInstanceId());
            msg.setControlDestination(protoMsg.getControlDestination());
            msg.setDataDestination(protoMsg.getDataDestination());
            msg.setDocumentSelection(RoutableFactories80.fromProtoDocumentSelection(protoMsg.getSelection()));
            msg.setFieldSet(RoutableFactories80.fromProtoFieldSet(protoMsg.getFieldSet()));
            msg.setMaxPendingReplyCount(protoMsg.getMaxPendingReplyCount());
            msg.setFromTimestamp(protoMsg.getFromTimestamp());
            msg.setToTimestamp(protoMsg.getToTimestamp());
            msg.setVisitRemoves(protoMsg.getVisitTombstones());
            msg.setVisitInconsistentBuckets(protoMsg.getVisitInconsistentBuckets());
            msg.setMaxBucketsPerVisitor(protoMsg.getMaxBucketsPerVisitor());
            for (DocapiCommon.BucketId protoId : protoMsg.getBucketsList()) {
                msg.getBuckets().add(RoutableFactories80.fromProtoBucketId(protoId));
            }
            for (DocapiVisiting.VisitorParameter protoParam : protoMsg.getParametersList()) {
                msg.getParameters().put(protoParam.getKey(), protoParam.getValue().toByteArray());
            }
            return msg;
        }).build();
    }

    static RoutableFactory createCreateVisitorReplyFactory() {
        return ProtobufCodecBuilder.of(CreateVisitorReply.class, DocapiVisiting.CreateVisitorResponse.class).encoder(apiReply -> {
            VisitorStatistics stats = apiReply.getVisitorStatistics();
            return DocapiVisiting.CreateVisitorResponse.newBuilder().setLastBucket(RoutableFactories80.toProtoBucketId(apiReply.getLastBucket())).setStatistics(DocapiVisiting.VisitorStatistics.newBuilder().setBucketsVisited(stats.getBucketsVisited()).setDocumentsVisited(stats.getDocumentsVisited()).setBytesVisited(stats.getBytesVisited()).setDocumentsReturned(stats.getDocumentsReturned()).setBytesReturned(stats.getBytesReturned()).build()).build();
        }).decoder(DocapiVisiting.CreateVisitorResponse.parser(), protoReply -> {
            CreateVisitorReply reply = new CreateVisitorReply(200007);
            reply.setLastBucket(RoutableFactories80.fromProtoBucketId(protoReply.getLastBucket()));
            DocapiVisiting.VisitorStatistics protoVs = protoReply.getStatistics();
            VisitorStatistics vs = new VisitorStatistics();
            vs.setBucketsVisited(protoVs.getBucketsVisited());
            vs.setDocumentsVisited(protoVs.getDocumentsVisited());
            vs.setBytesVisited(protoVs.getBytesVisited());
            vs.setDocumentsReturned(protoVs.getDocumentsReturned());
            vs.setBytesReturned(protoVs.getBytesReturned());
            reply.setVisitorStatistics(vs);
            return reply;
        }).build();
    }

    static RoutableFactory createDestroyVisitorMessageFactory() {
        return ProtobufCodecBuilder.of(DestroyVisitorMessage.class, DocapiVisiting.DestroyVisitorRequest.class).encoder(apiMsg -> DocapiVisiting.DestroyVisitorRequest.newBuilder().setInstanceId(apiMsg.getInstanceId()).build()).decoder(DocapiVisiting.DestroyVisitorRequest.parser(), protoMsg -> new DestroyVisitorMessage(protoMsg.getInstanceId())).build();
    }

    static RoutableFactory createDestroyVisitorReplyFactory() {
        return ProtobufCodecBuilder.of(VisitorReply.class, DocapiVisiting.DestroyVisitorResponse.class).encoder(apiReply -> DocapiVisiting.DestroyVisitorResponse.newBuilder().build()).decoder(DocapiVisiting.DestroyVisitorResponse.parser(), protoReply -> new VisitorReply(200008)).build();
    }

    static RoutableFactory createMapVisitorMessageFactory() {
        return ProtobufCodecBuilder.of(MapVisitorMessage.class, DocapiVisiting.MapVisitorRequest.class).encoder(apiMsg -> {
            DocapiVisiting.MapVisitorRequest.Builder builder = DocapiVisiting.MapVisitorRequest.newBuilder();
            for (Map.Entry<String, String> entry : apiMsg.getData().entrySet()) {
                builder.addData(RoutableFactories80.toProtoVisitorParameter(entry.getKey(), entry.getValue().getBytes(StandardCharsets.UTF_8)));
            }
            return builder.build();
        }).decoder(DocapiVisiting.MapVisitorRequest.parser(), protoMsg -> {
            MapVisitorMessage msg = new MapVisitorMessage();
            for (DocapiVisiting.VisitorParameter param : protoMsg.getDataList()) {
                msg.getData().put(param.getKey(), param.getValue().toStringUtf8());
            }
            return msg;
        }).build();
    }

    static RoutableFactory createMapVisitorReplyFactory() {
        return ProtobufCodecBuilder.of(VisitorReply.class, DocapiVisiting.MapVisitorResponse.class).encoder(apiReply -> DocapiVisiting.MapVisitorResponse.newBuilder().build()).decoder(DocapiVisiting.MapVisitorResponse.parser(), protoReply -> new VisitorReply(200015)).build();
    }

    static RoutableFactory createQueryResultMessageFactory() {
        return ProtobufCodecBuilder.of(QueryResultMessage.class, DocapiVisiting.QueryResultRequest.class).encoder(apiMsg -> {
            throw new UnsupportedOperationException("Serialization of QueryResultMessage instances is not supported");
        }).decoder(DocapiVisiting.QueryResultRequest.parser(), protoMsg -> {
            QueryResultMessage msg = new QueryResultMessage();
            if (!protoMsg.hasSearchResult() || !protoMsg.hasDocumentSummary()) {
                throw new IllegalArgumentException("Query result does not have all required fields set");
            }
            msg.setSearchResult(new SearchResult((Deserializer)new BufferSerializer(protoMsg.getSearchResult().getPayload().toByteArray())));
            msg.setSummary(new DocumentSummary((Deserializer)new BufferSerializer(protoMsg.getDocumentSummary().getPayload().toByteArray())));
            return msg;
        }).build();
    }

    static RoutableFactory createQueryResultReplyFactory() {
        return ProtobufCodecBuilder.of(VisitorReply.class, DocapiVisiting.QueryResultResponse.class).encoder(apiReply -> DocapiVisiting.QueryResultResponse.newBuilder().build()).decoder(DocapiVisiting.QueryResultResponse.parser(), protoReply -> new VisitorReply(200025)).build();
    }

    static RoutableFactory createVisitorInfoMessageFactory() {
        return ProtobufCodecBuilder.of(VisitorInfoMessage.class, DocapiVisiting.VisitorInfoRequest.class).encoder(apiMsg -> {
            DocapiVisiting.VisitorInfoRequest.Builder builder = DocapiVisiting.VisitorInfoRequest.newBuilder().setErrorMessage(apiMsg.getErrorMessage());
            for (BucketId id : apiMsg.getFinishedBuckets()) {
                builder.addFinishedBuckets(RoutableFactories80.toProtoBucketId(id));
            }
            return builder.build();
        }).decoder(DocapiVisiting.VisitorInfoRequest.parser(), protoMsg -> {
            VisitorInfoMessage msg = new VisitorInfoMessage();
            msg.setErrorMessage(protoMsg.getErrorMessage());
            for (DocapiCommon.BucketId protoId : protoMsg.getFinishedBucketsList()) {
                msg.getFinishedBuckets().add(RoutableFactories80.fromProtoBucketId(protoId));
            }
            return msg;
        }).build();
    }

    static RoutableFactory createVisitorInfoReplyFactory() {
        return ProtobufCodecBuilder.of(VisitorReply.class, DocapiVisiting.VisitorInfoResponse.class).encoder(apiReply -> DocapiVisiting.VisitorInfoResponse.newBuilder().build()).decoder(DocapiVisiting.VisitorInfoResponse.parser(), protoReply -> new VisitorReply(200009)).build();
    }

    static RoutableFactory createDocumentListMessageFactory() {
        return ProtobufCodecBuilder.of(DocumentListMessage.class, DocapiVisiting.DocumentListRequest.class).encoder(apiMsg -> {
            DocapiVisiting.DocumentListRequest.Builder builder = DocapiVisiting.DocumentListRequest.newBuilder().setBucketId(RoutableFactories80.toProtoBucketId(apiMsg.getBucketId()));
            for (DocumentListEntry doc : apiMsg.getDocuments()) {
                builder.addEntries(DocapiVisiting.DocumentListRequest.Entry.newBuilder().setTimestamp(doc.getTimestamp()).setIsTombstone(doc.isRemoveEntry()).setDocument(RoutableFactories80.toProtoDocument(doc.getDocument())));
            }
            return builder.build();
        }).decoderWithRepo(DocapiVisiting.DocumentListRequest.parser(), (protoMsg, repo) -> {
            DocumentListMessage msg = new DocumentListMessage();
            msg.setBucketId(RoutableFactories80.fromProtoBucketId(protoMsg.getBucketId()));
            for (DocapiVisiting.DocumentListRequest.Entry entry : protoMsg.getEntriesList()) {
                msg.getDocuments().add(new DocumentListEntry(RoutableFactories80.fromProtoDocument(entry.getDocument(), repo), entry.getTimestamp(), entry.getIsTombstone()));
            }
            return msg;
        }).build();
    }

    static RoutableFactory createDocumentListReplyFactory() {
        return ProtobufCodecBuilder.of(VisitorReply.class, DocapiVisiting.DocumentListResponse.class).encoder(apiReply -> DocapiVisiting.DocumentListResponse.newBuilder().build()).decoder(DocapiVisiting.DocumentListResponse.parser(), protoReply -> new VisitorReply(200021)).build();
    }

    static RoutableFactory createEmptyBucketsMessageFactory() {
        return ProtobufCodecBuilder.of(EmptyBucketsMessage.class, DocapiVisiting.EmptyBucketsRequest.class).encoder(apiMsg -> {
            DocapiVisiting.EmptyBucketsRequest.Builder builder = DocapiVisiting.EmptyBucketsRequest.newBuilder();
            for (BucketId id : apiMsg.getBucketIds()) {
                builder.addBucketIds(RoutableFactories80.toProtoBucketId(id));
            }
            return builder.build();
        }).decoder(DocapiVisiting.EmptyBucketsRequest.parser(), protoMsg -> {
            EmptyBucketsMessage msg = new EmptyBucketsMessage();
            for (DocapiCommon.BucketId protoId : protoMsg.getBucketIdsList()) {
                msg.getBucketIds().add(RoutableFactories80.fromProtoBucketId(protoId));
            }
            return msg;
        }).build();
    }

    static RoutableFactory createEmptyBucketsReplyFactory() {
        return ProtobufCodecBuilder.of(VisitorReply.class, DocapiVisiting.EmptyBucketsResponse.class).encoder(apiReply -> DocapiVisiting.EmptyBucketsResponse.newBuilder().build()).decoder(DocapiVisiting.EmptyBucketsResponse.parser(), protoReply -> new VisitorReply(200023)).build();
    }

    static RoutableFactory createGetBucketListMessageFactory() {
        return ProtobufCodecBuilder.of(GetBucketListMessage.class, DocapiInspect.GetBucketListRequest.class).encoder(apiMsg -> DocapiInspect.GetBucketListRequest.newBuilder().setBucketId(RoutableFactories80.toProtoBucketId(apiMsg.getBucketId())).setBucketSpace(RoutableFactories80.toProtoBucketSpace(apiMsg.getBucketSpace())).build()).decoder(DocapiInspect.GetBucketListRequest.parser(), protoMsg -> new GetBucketListMessage(RoutableFactories80.fromProtoBucketId(protoMsg.getBucketId()), RoutableFactories80.fromProtoBucketSpace(protoMsg.getBucketSpace()))).build();
    }

    static RoutableFactory createGetBucketListReplyFactory() {
        return ProtobufCodecBuilder.of(GetBucketListReply.class, DocapiInspect.GetBucketListResponse.class).encoder(apiReply -> {
            DocapiInspect.GetBucketListResponse.Builder builder = DocapiInspect.GetBucketListResponse.newBuilder();
            for (GetBucketListReply.BucketInfo info : apiReply.getBuckets()) {
                builder.addBucketInfo(DocapiInspect.BucketInformation.newBuilder().setBucketId(RoutableFactories80.toProtoBucketId(info.getBucketId())).setInfo(info.getBucketInformation()));
            }
            return builder.build();
        }).decoder(DocapiInspect.GetBucketListResponse.parser(), protoReply -> {
            GetBucketListReply reply = new GetBucketListReply();
            for (DocapiInspect.BucketInformation info : protoReply.getBucketInfoList()) {
                reply.getBuckets().add(new GetBucketListReply.BucketInfo(RoutableFactories80.fromProtoBucketId(info.getBucketId()), info.getInfo()));
            }
            return reply;
        }).build();
    }

    static RoutableFactory createGetBucketStateMessageFactory() {
        return ProtobufCodecBuilder.of(GetBucketStateMessage.class, DocapiInspect.GetBucketStateRequest.class).encoder(apiMsg -> DocapiInspect.GetBucketStateRequest.newBuilder().setBucketId(RoutableFactories80.toProtoBucketId(apiMsg.getBucketId())).build()).decoder(DocapiInspect.GetBucketStateRequest.parser(), protoMsg -> new GetBucketStateMessage(RoutableFactories80.fromProtoBucketId(protoMsg.getBucketId()))).build();
    }

    static RoutableFactory createGetBucketStateReplyFactory() {
        return ProtobufCodecBuilder.of(GetBucketStateReply.class, DocapiInspect.GetBucketStateResponse.class).encoder(apiReply -> {
            DocapiInspect.GetBucketStateResponse.Builder builder = DocapiInspect.GetBucketStateResponse.newBuilder();
            for (DocumentState state : apiReply.getBucketState()) {
                DocapiInspect.DocumentState.Builder stateBuilder = DocapiInspect.DocumentState.newBuilder().setTimestamp(state.getTimestamp()).setIsTombstone(state.isRemoveEntry());
                if (state.hasDocId()) {
                    stateBuilder.setDocumentId(RoutableFactories80.toProtoDocId(state.getDocId()));
                } else {
                    stateBuilder.setGlobalId(RoutableFactories80.toProtoGlobalId(state.getGid()));
                }
                builder.addStates(stateBuilder);
            }
            return builder.build();
        }).decoder(DocapiInspect.GetBucketStateResponse.parser(), protoReply -> {
            GetBucketStateReply reply = new GetBucketStateReply();
            for (DocapiInspect.DocumentState state : protoReply.getStatesList()) {
                if (state.hasDocumentId()) {
                    reply.getBucketState().add(new DocumentState(RoutableFactories80.fromProtoDocId(state.getDocumentId()), state.getTimestamp(), state.getIsTombstone()));
                    continue;
                }
                reply.getBucketState().add(new DocumentState(RoutableFactories80.fromProtoGlobalId(state.getGlobalId()), state.getTimestamp(), state.getIsTombstone()));
            }
            return reply;
        }).build();
    }

    static RoutableFactory createStatBucketMessageFactory() {
        return ProtobufCodecBuilder.of(StatBucketMessage.class, DocapiInspect.StatBucketRequest.class).encoder(apiMsg -> DocapiInspect.StatBucketRequest.newBuilder().setBucketId(RoutableFactories80.toProtoBucketId(apiMsg.getBucketId())).setBucketSpace(RoutableFactories80.toProtoBucketSpace(apiMsg.getBucketSpace())).setSelection(RoutableFactories80.toProtoDocumentSelection(apiMsg.getDocumentSelection())).build()).decoder(DocapiInspect.StatBucketRequest.parser(), protoMsg -> new StatBucketMessage(RoutableFactories80.fromProtoBucketId(protoMsg.getBucketId()), RoutableFactories80.fromProtoBucketSpace(protoMsg.getBucketSpace()), RoutableFactories80.fromProtoDocumentSelection(protoMsg.getSelection()))).build();
    }

    static RoutableFactory createStatBucketReplyFactory() {
        return ProtobufCodecBuilder.of(StatBucketReply.class, DocapiInspect.StatBucketResponse.class).encoder(apiReply -> DocapiInspect.StatBucketResponse.newBuilder().setResults(apiReply.getResults()).build()).decoder(DocapiInspect.StatBucketResponse.parser(), protoReply -> new StatBucketReply(protoReply.getResults())).build();
    }

    static RoutableFactory createWrongDistributionReplyFactory() {
        return ProtobufCodecBuilder.of(WrongDistributionReply.class, DocapiCommon.WrongDistributionResponse.class).encoder(apiReply -> DocapiCommon.WrongDistributionResponse.newBuilder().setClusterState(RoutableFactories80.toProtoClusterState(apiReply.getSystemState())).build()).decoder(DocapiCommon.WrongDistributionResponse.parser(), protoReply -> new WrongDistributionReply(RoutableFactories80.fromProtoClusterState(protoReply.getClusterState()))).build();
    }

    static RoutableFactory createDocumentIgnoredReplyFactory() {
        return ProtobufCodecBuilder.of(DocumentIgnoredReply.class, DocapiCommon.DocumentIgnoredResponse.class).encoder(apiReply -> DocapiCommon.DocumentIgnoredResponse.newBuilder().build()).decoder(DocapiCommon.DocumentIgnoredResponse.parser(), protoReply -> new DocumentIgnoredReply()).build();
    }

    private static class ProtobufCodecBuilder<DocApiT extends Routable, ProtoT extends AbstractMessage> {
        private final Class<DocApiT> apiClass;
        private final Class<ProtoT> protoClass;
        private Function<DocApiT, ProtoT> encoderFn;
        private Function<DocumentDeserializer, DocApiT> decoderFn;

        ProtobufCodecBuilder(Class<DocApiT> apiClass, Class<ProtoT> protoClass) {
            this.apiClass = apiClass;
            this.protoClass = protoClass;
        }

        static <DocApiT extends Routable, ProtoT extends AbstractMessage> ProtobufCodecBuilder<DocApiT, ProtoT> of(Class<DocApiT> apiClass, Class<ProtoT> protoClass) {
            return new ProtobufCodecBuilder<DocApiT, ProtoT>(apiClass, protoClass);
        }

        ProtobufCodecBuilder<DocApiT, ProtoT> encoder(Function<DocApiT, ProtoT> fn) {
            if (this.encoderFn != null) {
                throw new IllegalArgumentException("Encoder already set");
            }
            this.encoderFn = fn;
            return this;
        }

        ProtobufCodecBuilder<DocApiT, ProtoT> decoder(Parser<ProtoT> parser, Function<ProtoT, DocApiT> fn) {
            if (this.decoderFn != null) {
                throw new IllegalArgumentException("Decoder already set");
            }
            this.decoderFn = buf -> {
                try {
                    AbstractMessage protoObj = (AbstractMessage)parser.parseFrom(buf.getBuf().getByteBuffer());
                    return (Routable)fn.apply(protoObj);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            return this;
        }

        ProtobufCodecBuilder<DocApiT, ProtoT> decoderWithRepo(Parser<ProtoT> parser, BiFunction<ProtoT, DocumentTypeManager, DocApiT> fn) {
            if (this.decoderFn != null) {
                throw new IllegalArgumentException("Decoder already set");
            }
            this.decoderFn = buf -> {
                try {
                    AbstractMessage protoObj = (AbstractMessage)parser.parseFrom(buf.getBuf().getByteBuffer());
                    return (Routable)fn.apply(protoObj, buf.getTypeRepo());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            return this;
        }

        ProtobufCodec<DocApiT, ProtoT> build() {
            Objects.requireNonNull(this.encoderFn, "Encoder has not been set");
            Objects.requireNonNull(this.decoderFn, "Decoder has not been set");
            return new ProtobufCodec<DocApiT, ProtoT>(this.apiClass, this.encoderFn, this.decoderFn);
        }
    }

    private static class ProtobufCodec<DocApiT extends Routable, ProtoT extends AbstractMessage>
    implements RoutableFactory {
        private final Class<DocApiT> apiClass;
        private final Function<DocApiT, ProtoT> encoderFn;
        private final Function<DocumentDeserializer, DocApiT> decoderFn;

        ProtobufCodec(Class<DocApiT> apiClass, Function<DocApiT, ProtoT> encoderFn, Function<DocumentDeserializer, DocApiT> decoderFn) {
            this.apiClass = apiClass;
            this.encoderFn = encoderFn;
            this.decoderFn = decoderFn;
        }

        @Override
        public byte[] encode(int msgType, Routable obj) {
            try {
                AbstractMessage protoMsg = (AbstractMessage)this.encoderFn.apply((Routable)this.apiClass.cast(obj));
                int protoSize = protoMsg.getSerializedSize();
                byte[] buf = new byte[4 + protoSize];
                ByteBuffer.wrap(buf).putInt(msgType);
                CodedOutputStream protoStream = CodedOutputStream.newInstance((byte[])buf, (int)4, (int)protoSize);
                protoMsg.writeTo(protoStream);
                protoStream.checkNoSpaceLeft();
                return buf;
            }
            catch (IOException | RuntimeException e) {
                log.severe("Error during Protobuf encoding of message type %s: %s".formatted(this.apiClass.getSimpleName(), Exceptions.toMessageString((Throwable)e)));
                log.log(Level.FINE, "Protobuf encode error has exception trace:", e);
                return null;
            }
        }

        @Override
        public boolean encode(Routable obj, DocumentSerializer out) {
            return false;
        }

        @Override
        public Routable decode(DocumentDeserializer in) {
            try {
                return (Routable)this.decoderFn.apply(in);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error during Protobuf decoding of message type %s: %s".formatted(this.apiClass.getSimpleName(), e.getMessage()), e);
            }
        }
    }
}

