/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.document.fieldset.FieldSet;
import com.yahoo.document.fieldset.FieldSetRepo;
import com.yahoo.documentapi.ResponseHandler;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class DocumentOperationParameters {
    private static final DocumentOperationParameters empty = new DocumentOperationParameters(null, null, null, -1, null, null);
    private final DocumentProtocol.Priority priority;
    private final String fieldSet;
    private final String route;
    private final int traceLevel;
    private final Instant deadline;
    private final ResponseHandler responseHandler;

    private DocumentOperationParameters(DocumentProtocol.Priority priority, String fieldSet, String route, int traceLevel, Instant deadline, ResponseHandler responseHandler) {
        this.priority = priority;
        this.fieldSet = fieldSet;
        this.route = route;
        this.traceLevel = traceLevel;
        this.deadline = deadline;
        this.responseHandler = responseHandler;
    }

    public static DocumentOperationParameters parameters() {
        return empty;
    }

    public DocumentOperationParameters withFieldSet(FieldSet fieldSet) {
        return new DocumentOperationParameters(this.priority, new FieldSetRepo().serialize(fieldSet), this.route, this.traceLevel, this.deadline, this.responseHandler);
    }

    public DocumentOperationParameters withFieldSet(String fieldSet) {
        return new DocumentOperationParameters(this.priority, Objects.requireNonNull(fieldSet), this.route, this.traceLevel, this.deadline, this.responseHandler);
    }

    public DocumentOperationParameters withRoute(String route) {
        return new DocumentOperationParameters(this.priority, this.fieldSet, Objects.requireNonNull(route), this.traceLevel, this.deadline, this.responseHandler);
    }

    public DocumentOperationParameters withTraceLevel(int traceLevel) {
        if (traceLevel < 0 || traceLevel > 9) {
            throw new IllegalArgumentException("Trace level must be from 0 (no tracing) to 9 (maximum)");
        }
        return new DocumentOperationParameters(this.priority, this.fieldSet, this.route, traceLevel, this.deadline, this.responseHandler);
    }

    public DocumentOperationParameters withDeadline(Instant deadline) {
        return new DocumentOperationParameters(this.priority, this.fieldSet, this.route, this.traceLevel, Objects.requireNonNull(deadline), this.responseHandler);
    }

    public DocumentOperationParameters withResponseHandler(ResponseHandler responseHandler) {
        return new DocumentOperationParameters(this.priority, this.fieldSet, this.route, this.traceLevel, this.deadline, Objects.requireNonNull(responseHandler));
    }

    public Optional<String> fieldSet() {
        return Optional.ofNullable(this.fieldSet);
    }

    public Optional<String> route() {
        return Optional.ofNullable(this.route);
    }

    public OptionalInt traceLevel() {
        return this.traceLevel >= 0 ? OptionalInt.of(this.traceLevel) : OptionalInt.empty();
    }

    public Optional<Instant> deadline() {
        return Optional.ofNullable(this.deadline);
    }

    public Optional<ResponseHandler> responseHandler() {
        return Optional.ofNullable(this.responseHandler);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentOperationParameters that = (DocumentOperationParameters)o;
        return this.traceLevel == that.traceLevel && this.priority == that.priority && Objects.equals(this.fieldSet, that.fieldSet) && Objects.equals(this.route, that.route);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priority, this.fieldSet, this.route, this.traceLevel});
    }

    public String toString() {
        return "DocumentOperationParameters{priority=" + String.valueOf((Object)this.priority) + ", fieldSet='" + this.fieldSet + "', route='" + this.route + "', traceLevel=" + this.traceLevel + "}";
    }
}

