/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.messagebus.Error;

public class Result {
    private final Error error;
    private final long requestId;
    private final ResultType type;

    public Result() {
        this(0L);
    }

    public Result(long requestId) {
        this.error = null;
        this.requestId = requestId;
        this.type = ResultType.SUCCESS;
    }

    public Result(ResultType type, Error error) {
        this.type = type;
        this.error = error;
        this.requestId = 0L;
    }

    public boolean isSuccess() {
        return this.type == ResultType.SUCCESS;
    }

    public Error error() {
        return this.error;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public ResultType type() {
        return this.type;
    }

    public static Error toError(ResultType result) {
        switch (result) {
            case TRANSIENT_ERROR: {
                return new Error(100000, ResultType.TRANSIENT_ERROR.name());
            }
            case FATAL_ERROR: {
                return new Error(200000, ResultType.FATAL_ERROR.name());
            }
        }
        return new Error(0, "SUCCESS");
    }

    public static enum ResultType {
        SUCCESS,
        TRANSIENT_ERROR,
        FATAL_ERROR;

    }
}

