/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.api.annotations.Beta;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.LazyDecoder;
import com.yahoo.documentapi.messagebus.protocol.TestAndSetMessage;
import com.yahoo.documentapi.messagebus.protocol.WriteDocumentReply;
import com.yahoo.messagebus.Routable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PutDocumentMessage
extends TestAndSetMessage {
    private DocumentPut put = null;
    private long time = 0L;
    private DocumentDeserializer buffer = null;
    private LazyDecoder decoder = null;

    public PutDocumentMessage(LazyDecoder decoder, DocumentDeserializer buffer) {
        this.decoder = decoder;
        this.buffer = buffer;
    }

    public PutDocumentMessage(DocumentPut put) {
        this.put = put;
    }

    public static PutDocumentMessage createEmpty() {
        return new PutDocumentMessage(null);
    }

    private void deserialize() {
        if (this.decoder != null && this.buffer != null) {
            this.decoder.decode((Routable)this, this.buffer);
            this.decoder = null;
            this.buffer = null;
        }
    }

    public DocumentPut getDocumentPut() {
        this.deserialize();
        return this.put;
    }

    public void setDocumentPut(DocumentPut put) {
        this.buffer = null;
        this.decoder = null;
        this.put = put;
    }

    public long getTimestamp() {
        this.deserialize();
        return this.time;
    }

    public void setTimestamp(long time) {
        this.buffer = null;
        this.decoder = null;
        this.time = time;
    }

    ByteBuffer getSerializedBuffer() {
        return this.buffer != null ? this.buffer.getBuf().getByteBuffer() : null;
    }

    @Override
    public DocumentReply createReply() {
        return new WriteDocumentReply(200004);
    }

    @Override
    public int getApproxSize() {
        if (this.buffer != null) {
            return this.buffer.getBuf().remaining();
        }
        return this.put.getDocument().getApproxSize();
    }

    public boolean hasSequenceId() {
        return true;
    }

    public long getSequenceId() {
        this.deserialize();
        return Arrays.hashCode(this.put.getId().getGlobalId());
    }

    public int getType() {
        return 100004;
    }

    @Override
    public TestAndSetCondition getCondition() {
        this.deserialize();
        return this.put.getCondition();
    }

    @Override
    public void setCondition(TestAndSetCondition condition) {
        this.put.setCondition(condition);
    }

    @Beta
    public void setCreateIfNonExistent(boolean value) {
        this.put.setCreateIfNonExistent(value);
    }

    @Beta
    public boolean getCreateIfNonExistent() {
        this.deserialize();
        return this.put.getCreateIfNonExistent();
    }
}

