/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.LazyDecoder;
import com.yahoo.documentapi.messagebus.protocol.TestAndSetMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.messagebus.Routable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class UpdateDocumentMessage
extends TestAndSetMessage {
    private DocumentUpdate update = null;
    private long oldTime = 0L;
    private long newTime = 0L;
    private DocumentDeserializer buffer = null;
    private LazyDecoder decoder = null;

    public UpdateDocumentMessage(LazyDecoder decoder, DocumentDeserializer buffer) {
        this.decoder = decoder;
        this.buffer = buffer;
    }

    public UpdateDocumentMessage(DocumentUpdate upd) {
        this.update = upd;
    }

    public static UpdateDocumentMessage createEmpty() {
        return new UpdateDocumentMessage(null);
    }

    private void deserialize() {
        if (this.decoder != null && this.buffer != null) {
            this.decoder.decode((Routable)this, this.buffer);
            this.decoder = null;
            this.buffer = null;
        }
    }

    public DocumentUpdate getDocumentUpdate() {
        this.deserialize();
        return this.update;
    }

    public void setDocumentUpdate(DocumentUpdate upd) {
        if (upd == null) {
            throw new IllegalArgumentException("Document update can not be null.");
        }
        this.buffer = null;
        this.decoder = null;
        this.update = upd;
    }

    public long getOldTimestamp() {
        this.deserialize();
        return this.oldTime;
    }

    public void setOldTimestamp(long time) {
        this.buffer = null;
        this.decoder = null;
        this.oldTime = time;
    }

    public long getNewTimestamp() {
        this.deserialize();
        return this.newTime;
    }

    public void setNewTimestamp(long time) {
        this.buffer = null;
        this.decoder = null;
        this.newTime = time;
    }

    ByteBuffer getSerializedBuffer() {
        return this.buffer != null ? this.buffer.getBuf().getByteBuffer() : null;
    }

    @Override
    public DocumentReply createReply() {
        return new UpdateDocumentReply();
    }

    public boolean hasSequenceId() {
        return true;
    }

    public long getSequenceId() {
        this.deserialize();
        return Arrays.hashCode(this.update.getId().getGlobalId());
    }

    public int getType() {
        return 100006;
    }

    @Override
    public TestAndSetCondition getCondition() {
        this.deserialize();
        return this.update.getCondition();
    }

    @Override
    public void setCondition(TestAndSetCondition condition) {
        this.update.setCondition(condition);
    }
}

