/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class DocumentProtocolPoliciesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "b97766709a49f349f355d4379d6f9afa";
    public static final String CONFIG_DEF_NAME = "document-protocol-policies";
    public static final String CONFIG_DEF_NAMESPACE = "documentapi.messagebus.protocol";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=documentapi.messagebus.protocol", "cluster{}.defaultRoute string", "cluster{}.route[].name string", "cluster{}.route[].messageType int", "cluster{}.selector string"};
    private final Map<String, Cluster> cluster;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DocumentProtocolPoliciesConfig(Builder builder) {
        this(builder, true);
    }

    private DocumentProtocolPoliciesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for document-protocol-policies must be initialized: " + builder.__uninitialized);
        }
        this.cluster = Cluster.createMap(builder.cluster);
    }

    public Map<String, Cluster> cluster() {
        return Collections.unmodifiableMap(this.cluster);
    }

    public Cluster cluster(String key) {
        return this.cluster.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DocumentProtocolPoliciesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Map<String, Cluster.Builder> cluster = new LinkedHashMap<String, Cluster.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DocumentProtocolPoliciesConfig config) {
            for (Map.Entry<String, Cluster> __entry : config.cluster().entrySet()) {
                this.cluster(__entry.getKey(), new Cluster.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            this.cluster(__superior.cluster);
            return this;
        }

        public Builder cluster(String __key, Cluster.Builder __value) {
            this.cluster.put(__key, __value);
            return this;
        }

        public Builder cluster(Map<String, Cluster.Builder> __values) {
            this.cluster.putAll(__values);
            return this;
        }

        public Builder cluster(String __key, Consumer<Cluster.Builder> __func) {
            Cluster.Builder __inner = new Cluster.Builder();
            __func.accept(__inner);
            this.cluster.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DocumentProtocolPoliciesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DocumentProtocolPoliciesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DocumentProtocolPoliciesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DocumentProtocolPoliciesConfig build() {
            return new DocumentProtocolPoliciesConfig(this);
        }
    }

    public static final class Cluster
    extends InnerNode {
        private final StringNode defaultRoute;
        private final InnerNodeVector<Route> route;
        private final StringNode selector;

        public Cluster(Builder builder) {
            this(builder, true);
        }

        private Cluster(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for document-protocol-policies.cluster{} must be initialized: " + builder.__uninitialized);
            }
            this.defaultRoute = builder.defaultRoute == null ? new StringNode() : new StringNode(builder.defaultRoute);
            this.route = Route.createVector(builder.route);
            this.selector = builder.selector == null ? new StringNode() : new StringNode(builder.selector);
        }

        public String defaultRoute() {
            return this.defaultRoute.value();
        }

        public List<Route> route() {
            return this.route;
        }

        public Route route(int i) {
            return (Route)((Object)this.route.get(i));
        }

        public String selector() {
            return this.selector.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Cluster newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster");
            return changes;
        }

        private static Map<String, Cluster> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Cluster> ret = new LinkedHashMap<String, Cluster>();
            for (String key : builders.keySet()) {
                ret.put(key, new Cluster(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("defaultRoute", "selector"));
            private String defaultRoute = null;
            public List<Route.Builder> route = new ArrayList<Route.Builder>();
            private String selector = null;

            public Builder() {
            }

            public Builder(Cluster config) {
                this.defaultRoute(config.defaultRoute());
                for (Route r : config.route()) {
                    this.route(new Route.Builder(r));
                }
                this.selector(config.selector());
            }

            private Builder override(Builder __superior) {
                if (__superior.defaultRoute != null) {
                    this.defaultRoute(__superior.defaultRoute);
                }
                if (!__superior.route.isEmpty()) {
                    this.route.addAll(__superior.route);
                }
                if (__superior.selector != null) {
                    this.selector(__superior.selector);
                }
                return this;
            }

            public Builder defaultRoute(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.defaultRoute = __value;
                this.__uninitialized.remove("defaultRoute");
                return this;
            }

            public Builder route(Route.Builder __builder) {
                this.route.add(__builder);
                return this;
            }

            public Builder route(Consumer<Route.Builder> __func) {
                Route.Builder __inner = new Route.Builder();
                __func.accept(__inner);
                this.route.add(__inner);
                return this;
            }

            public Builder route(List<Route.Builder> __builders) {
                this.route = __builders;
                return this;
            }

            public Builder selector(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.selector = __value;
                this.__uninitialized.remove("selector");
                return this;
            }

            public Cluster build() {
                return new Cluster(this);
            }
        }

        public static final class Route
        extends InnerNode {
            private final StringNode name;
            private final IntegerNode messageType;

            public Route(Builder builder) {
                this(builder, true);
            }

            private Route(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for document-protocol-policies.cluster{}.route[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.messageType = builder.messageType == null ? new IntegerNode() : new IntegerNode(builder.messageType.intValue());
            }

            public String name() {
                return this.name.value();
            }

            public int messageType() {
                return this.messageType.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Route newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("route");
                return changes;
            }

            private static InnerNodeVector<Route> createVector(List<Builder> builders) {
                ArrayList<Route> elems = new ArrayList<Route>();
                for (Builder b : builders) {
                    elems.add(new Route(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "messageType"));
                private String name = null;
                private Integer messageType = null;

                public Builder() {
                }

                public Builder(Route config) {
                    this.name(config.name());
                    this.messageType(config.messageType());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.messageType != null) {
                        this.messageType(__superior.messageType);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder messageType(int __value) {
                    this.messageType = __value;
                    this.__uninitialized.remove("messageType");
                    return this;
                }

                private Builder messageType(String __value) {
                    return this.messageType(Integer.valueOf(__value));
                }

                public Route build() {
                    return new Route(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

