/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.local;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentIdResponse;
import com.yahoo.documentapi.DocumentResponse;
import com.yahoo.documentapi.DocumentUpdateResponse;
import com.yahoo.documentapi.RemoveResponse;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.ResponseHandler;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.SyncSession;
import com.yahoo.documentapi.UpdateResponse;
import com.yahoo.documentapi.local.LocalDocumentAccess;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class LocalAsyncSession
implements AsyncSession {
    private final List<Response> responses = new LinkedList<Response>();
    private final ResponseHandler handler;
    private final SyncSession syncSession;
    private long requestId = 0L;
    private Random random = new Random();

    private synchronized long getNextRequestId() {
        ++this.requestId;
        return this.requestId;
    }

    public LocalAsyncSession(AsyncParameters params, LocalDocumentAccess access) {
        this.handler = params.getResponseHandler();
        this.random.setSeed(System.currentTimeMillis());
        this.syncSession = access.createSyncSession(new SyncParameters.Builder().build());
    }

    @Override
    public double getCurrentWindowSize() {
        return 1000.0;
    }

    @Override
    public Result put(Document document) {
        return this.put(document, DocumentProtocol.Priority.NORMAL_3);
    }

    @Override
    public Result put(Document document, DocumentProtocol.Priority pri) {
        long req = this.getNextRequestId();
        try {
            this.syncSession.put(new DocumentPut(document), pri);
            this.addResponse(new DocumentResponse(req));
        }
        catch (Exception e) {
            this.addResponse(new DocumentResponse(req, document, e.getMessage(), false));
        }
        return new Result(req);
    }

    @Override
    public Result get(DocumentId id) {
        return this.get(id, false, DocumentProtocol.Priority.NORMAL_3);
    }

    @Override
    @Deprecated
    public Result get(DocumentId id, boolean headersOnly, DocumentProtocol.Priority pri) {
        return this.get(id, pri);
    }

    @Override
    public Result get(DocumentId id, DocumentProtocol.Priority pri) {
        long req = this.getNextRequestId();
        try {
            this.addResponse(new DocumentResponse(req, this.syncSession.get(id)));
        }
        catch (Exception e) {
            this.addResponse(new DocumentResponse(req, e.getMessage(), false));
        }
        return new Result(req);
    }

    @Override
    public Result remove(DocumentId id) {
        return this.remove(id, DocumentProtocol.Priority.NORMAL_3);
    }

    @Override
    public Result remove(DocumentId id, DocumentProtocol.Priority pri) {
        long req = this.getNextRequestId();
        if (this.syncSession.remove(new DocumentRemove(id), pri)) {
            this.addResponse(new RemoveResponse(req, true));
        } else {
            this.addResponse(new DocumentIdResponse(req, id, "Document not found.", false));
        }
        return new Result(req);
    }

    @Override
    public Result update(DocumentUpdate update) {
        return this.update(update, DocumentProtocol.Priority.NORMAL_3);
    }

    @Override
    public Result update(DocumentUpdate update, DocumentProtocol.Priority pri) {
        long req = this.getNextRequestId();
        if (this.syncSession.update(update, pri)) {
            this.addResponse(new UpdateResponse(req, true));
        } else {
            this.addResponse(new DocumentUpdateResponse(req, update, "Document not found.", false));
        }
        return new Result(req);
    }

    @Override
    public Response getNext() {
        if (this.responses.isEmpty()) {
            return null;
        }
        int index = this.random.nextInt(this.responses.size());
        return this.responses.remove(index);
    }

    @Override
    public Response getNext(int timeout) {
        return this.getNext();
    }

    @Override
    public void destroy() {
    }

    private void addResponse(Response response) {
        if (this.handler != null) {
            this.handler.handleResponse(response);
        } else {
            this.responses.add(response);
        }
    }
}

