/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.VerbatimDirective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SubsetServicePolicy
implements DocumentProtocolRoutingPolicy {
    private static Logger log = Logger.getLogger(SubsetServicePolicy.class.getName());
    private final int subsetSize;
    private final Map<String, CacheEntry> cache = new HashMap<String, CacheEntry>();

    SubsetServicePolicy(String param) {
        int subsetSize = 5;
        if (param != null && param.length() > 0) {
            try {
                subsetSize = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                log.log(LogLevel.WARNING, "Parameter '" + param + "' could not be parsed as an integer.", e);
            }
            if (subsetSize <= 0) {
                log.warning("Ignoring a request to set the subset size to " + subsetSize + " because it makes no sense. This routing policy will choose any one matching service.");
            }
        } else {
            log.warning("No parameter given to SubsetService policy, using default value " + subsetSize + ".");
        }
        this.subsetSize = subsetSize;
    }

    public void select(RoutingContext ctx) {
        Route route = new Route(ctx.getRoute());
        route.setHop(0, this.getRecipient(ctx));
        ctx.addChild(route);
    }

    public void merge(RoutingContext ctx) {
        DocumentProtocol.merge(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hop getRecipient(RoutingContext ctx) {
        Hop hop = null;
        if (this.subsetSize > 0) {
            SubsetServicePolicy subsetServicePolicy = this;
            synchronized (subsetServicePolicy) {
                CacheEntry entry = this.update(ctx);
                if (!entry.recipients.isEmpty()) {
                    if (++entry.offset >= entry.recipients.size()) {
                        entry.offset = 0;
                    }
                    hop = new Hop(entry.recipients.get(entry.offset));
                }
            }
        }
        if (hop == null) {
            hop = new Hop(ctx.getRoute().getHop(0));
            hop.setDirective(ctx.getDirectiveIndex(), (HopDirective)new VerbatimDirective("*"));
        }
        return hop;
    }

    private CacheEntry update(RoutingContext ctx) {
        int upd;
        String key = this.getCacheKey(ctx);
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            entry = new CacheEntry();
            this.cache.put(key, entry);
        }
        if (entry.generation != (upd = ctx.getMirror().updates())) {
            entry.generation = upd;
            entry.recipients.clear();
            List arr = ctx.getMirror().lookup(ctx.getHopPrefix() + "*" + ctx.getHopSuffix());
            int pos = ctx.getMessageBus().getConnectionSpec().hashCode();
            for (int i = 0; i < this.subsetSize && i < arr.size(); ++i) {
                entry.recipients.add(Hop.parse((String)((Mirror.Entry)arr.get((pos + i & Integer.MAX_VALUE) % arr.size())).getName()));
            }
        }
        return entry;
    }

    private String getCacheKey(RoutingContext ctx) {
        return ctx.getRoute().getHop(0).toString();
    }

    public void destroy() {
    }

    private class CacheEntry {
        private final List<Hop> recipients = new ArrayList<Hop>();
        private int generation = 0;
        private int offset = 0;

        private CacheEntry() {
        }
    }
}

