/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.loadtypes;

import com.yahoo.config.subscription.ConfigGetter;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LoadTypeSet {
    DualMap map;

    public LoadTypeSet() {
        this.map = new DualMap();
        this.map.put(LoadType.DEFAULT);
    }

    public LoadTypeSet(String configId) {
        this.configure((LoadTypeConfig)new ConfigGetter(LoadTypeConfig.class).getConfig(configId));
    }

    public LoadTypeSet(LoadTypeConfig loadTypeConfig) {
        this.configure(loadTypeConfig);
    }

    public Map<String, LoadType> getNameMap() {
        return this.map.nameMap;
    }

    public Map<Integer, LoadType> getIdMap() {
        return this.map.idMap;
    }

    public void addType(String name, String priority) {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(name.getBytes());
            byte[] messageDigest = algorithm.digest();
            int id = 0;
            for (int i = 0; i < 4; ++i) {
                int temp = messageDigest[i] & 0xFF;
                id <<= 8;
                id |= temp;
            }
            this.map.put(new LoadType(id, name, DocumentProtocol.Priority.valueOf(priority != null ? priority : "NORMAL_3")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void addLoadType(int id, String name, DocumentProtocol.Priority priority) {
        this.map.put(new LoadType(id, name, priority));
    }

    public void configure(LoadTypeConfig config) {
        DualMap newMap = new DualMap();
        newMap.put(LoadType.DEFAULT);
        for (LoadTypeConfig.Type t : config.type()) {
            newMap.put(new LoadType(t.id(), t.name(), DocumentProtocol.Priority.valueOf(t.priority())));
        }
        this.map = newMap;
    }

    class DualMap {
        Map<String, LoadType> nameMap = new TreeMap<String, LoadType>();
        Map<Integer, LoadType> idMap = new HashMap<Integer, LoadType>();

        DualMap() {
        }

        void put(LoadType l) {
            if (this.nameMap.containsKey(l.getName()) || this.idMap.containsKey(l.getId())) {
                throw new IllegalArgumentException("ID or name conflict when adding " + l);
            }
            this.nameMap.put(l.getName(), l);
            this.idMap.put(l.getId(), l);
        }
    }
}

