/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.metrics.CountMetric;
import com.yahoo.messagebus.metrics.Metric;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.metrics.ValueMetric;
import java.util.ArrayList;
import java.util.List;

public class LoadBalancer {
    private List<NodeMetrics> nodeWeights = new ArrayList<NodeMetrics>();
    private Metrics metrics;
    private String cluster;
    private double position = 0.0;

    public LoadBalancer(String cluster, String session, Metrics metrics) {
        this.metrics = metrics;
        this.cluster = cluster;
    }

    public List<NodeMetrics> getNodeWeights() {
        return this.nodeWeights;
    }

    public int getIndex(String nodeName) {
        try {
            String s = nodeName.substring(this.cluster.length() + 1);
            s = s.substring(0, s.indexOf("/"));
            s = s.substring(s.lastIndexOf(".") + 1);
            return Integer.parseInt(s);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            String err = "Expected recipient on the form '" + this.cluster + "/x/[y.]number/z', got '" + nodeName + "'.";
            throw new IllegalArgumentException(err, e);
        }
    }

    public Node getRecipient(Mirror.Entry[] choices) {
        if (choices.length == 0) {
            return null;
        }
        double weightSum = 0.0;
        Node selectedNode = null;
        for (Mirror.Entry entry : choices) {
            NodeMetrics nodeMetrics = this.getNodeMetrics(entry);
            if (!((weightSum += ((Double)nodeMetrics.weight.get()).doubleValue()) > this.position)) continue;
            selectedNode = new Node(entry, nodeMetrics);
            break;
        }
        if (selectedNode == null) {
            this.position -= weightSum;
            selectedNode = new Node(choices[0], this.getNodeMetrics(choices[0]));
        }
        this.position += 1.0;
        selectedNode.metrics.sent.inc(1L);
        return selectedNode;
    }

    private NodeMetrics getNodeMetrics(Mirror.Entry entry) {
        int index = this.getIndex(entry.getName());
        while (this.nodeWeights.size() < index + 1) {
            this.nodeWeights.add(null);
        }
        NodeMetrics nodeMetrics = this.nodeWeights.get(index);
        if (nodeMetrics == null) {
            nodeMetrics = new NodeMetrics("node_" + index, this.metrics.targets);
            this.nodeWeights.set(index, nodeMetrics);
        }
        return nodeMetrics;
    }

    private void increaseWeights() {
        for (NodeMetrics n : this.nodeWeights) {
            if (n == null) continue;
            double want = (Double)n.weight.get() * 1.0101010101010102;
            if (want >= 1.0) {
                n.weight.set((Number)want);
                continue;
            }
            n.weight.set((Number)1.0);
        }
    }

    public void received(Node node, boolean busy) {
        if (busy) {
            double wantWeight = (Double)node.metrics.weight.get() - 0.01;
            if (wantWeight < 1.0) {
                this.increaseWeights();
                node.metrics.weight.set((Number)1.0);
            } else {
                node.metrics.weight.set((Number)wantWeight);
            }
            node.metrics.busy.inc(1L);
        }
    }

    public static class Node {
        public Mirror.Entry entry;
        public NodeMetrics metrics;

        public Node(Mirror.Entry e, NodeMetrics m) {
            this.entry = e;
            this.metrics = m;
        }
    }

    public static class Metrics
    extends MetricSet {
        MetricSet targets = new MetricSet("nodes");

        public Metrics(String name) {
            super(name);
            this.addMetric((Metric)this.targets);
        }
    }

    public static class NodeMetrics
    extends MetricSet {
        public CountMetric sent = new CountMetric("sent", (MetricSet)this);
        public CountMetric busy = new CountMetric("busy", (MetricSet)this);
        public ValueMetric<Double> weight = new ValueMetric("weight", (Number)1.0, (MetricSet)this);

        public NodeMetrics(String name, MetricSet owner) {
            super(name);
            owner.addMetric((Metric)this);
        }
    }
}

