/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactory;
import com.yahoo.messagebus.routing.RoutingPolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class RoutingPolicyRepository {
    private static final Logger log = Logger.getLogger(RoutingPolicyRepository.class.getName());
    private final Map<String, RoutingPolicyFactory> factories = new ConcurrentHashMap<String, RoutingPolicyFactory>();

    RoutingPolicyRepository() {
    }

    void putFactory(String name, RoutingPolicyFactory factory) {
        this.factories.put(name, factory);
    }

    private RoutingPolicyFactory getFactory(String name) {
        return this.factories.get(name);
    }

    RoutingPolicy createPolicy(String name, String param) {
        RoutingPolicyFactory factory = this.getFactory(name);
        if (factory == null) {
            log.log(Level.SEVERE, "No routing policy factory found for name '" + name + "'.");
            return null;
        }
        DocumentProtocolRoutingPolicy ret = factory.createPolicy(param);
        if (ret == null) {
            log.log(Level.SEVERE, "Routing policy factory " + factory.getClass().getName() + " failed to create a routing policy for parameter '" + name + "'.");
            return null;
        }
        return ret;
    }
}

