/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.LoadBalancer;
import com.yahoo.jrt.slobrok.api.Mirror;
import java.util.List;
import java.util.Random;

class AdaptiveLoadBalancer
extends LoadBalancer {
    private final Random random;

    AdaptiveLoadBalancer(String cluster) {
        this(cluster, new Random());
    }

    AdaptiveLoadBalancer(String cluster, Random random) {
        super(cluster);
        this.random = random;
    }

    @Override
    LoadBalancer.Node getRecipient(List<Mirror.Entry> choices) {
        LoadBalancer.NodeMetrics metrics;
        Mirror.Entry entry;
        if (choices.isEmpty()) {
            return null;
        }
        if (choices.size() == 1) {
            entry = choices.get(0);
            metrics = this.getNodeMetrics(entry);
        } else {
            int candA = this.random.nextInt(choices.size());
            int candB = this.random.nextInt(choices.size());
            while (candB == candA) {
                candB = this.random.nextInt(choices.size());
            }
            entry = choices.get(candA);
            Mirror.Entry entryB = choices.get(candB);
            metrics = this.getNodeMetrics(entry);
            LoadBalancer.NodeMetrics metricsB = this.getNodeMetrics(entryB);
            if (metrics.pending() > metricsB.pending()) {
                entry = entryB;
                metrics = metricsB;
            }
        }
        metrics.incSend();
        return new LoadBalancer.Node(entry, metrics);
    }

    @Override
    void received(LoadBalancer.Node node, boolean busy) {
        node.metrics.incReceived();
        if (busy) {
            node.metrics.incBusy();
        }
    }
}

