/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.document.fieldset.FieldSet;
import com.yahoo.document.fieldset.FieldSetRepo;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class DocumentOperationParameters {
    private static final DocumentOperationParameters empty = new DocumentOperationParameters(null, null, null, -1);
    private final DocumentProtocol.Priority priority;
    private final String fieldSet;
    private final String route;
    private final int traceLevel;

    private DocumentOperationParameters(DocumentProtocol.Priority priority, String fieldSet, String route, int traceLevel) {
        this.priority = priority;
        this.fieldSet = fieldSet;
        this.route = route;
        this.traceLevel = traceLevel;
    }

    public static DocumentOperationParameters parameters() {
        return empty;
    }

    public DocumentOperationParameters withPriority(DocumentProtocol.Priority priority) {
        return new DocumentOperationParameters(Objects.requireNonNull(priority), this.fieldSet, this.route, this.traceLevel);
    }

    public DocumentOperationParameters withFieldSet(FieldSet fieldSet) {
        return new DocumentOperationParameters(this.priority, new FieldSetRepo().serialize(fieldSet), this.route, this.traceLevel);
    }

    public DocumentOperationParameters withFieldSet(String fieldSet) {
        return new DocumentOperationParameters(this.priority, Objects.requireNonNull(fieldSet), this.route, this.traceLevel);
    }

    public DocumentOperationParameters withRoute(String route) {
        return new DocumentOperationParameters(this.priority, this.fieldSet, Objects.requireNonNull(route), this.traceLevel);
    }

    public DocumentOperationParameters withTraceLevel(int traceLevel) {
        if (traceLevel < 0 || traceLevel > 9) {
            throw new IllegalArgumentException("Trace level must be from 0 (no tracing) to 9 (maximum)");
        }
        return new DocumentOperationParameters(this.priority, this.fieldSet, this.route, traceLevel);
    }

    public Optional<DocumentProtocol.Priority> priority() {
        return Optional.ofNullable(this.priority);
    }

    public Optional<String> fieldSet() {
        return Optional.ofNullable(this.fieldSet);
    }

    public Optional<String> route() {
        return Optional.ofNullable(this.route);
    }

    public OptionalInt traceLevel() {
        return this.traceLevel >= 0 ? OptionalInt.of(this.traceLevel) : OptionalInt.empty();
    }
}

