/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.LoadBalancer;
import com.yahoo.jrt.slobrok.api.Mirror;
import java.util.List;

class LegacyLoadBalancer
extends LoadBalancer {
    private double position = 0.0;

    public LegacyLoadBalancer(String cluster) {
        super(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LoadBalancer.Node getRecipient(List<Mirror.Entry> choices) {
        if (choices.isEmpty()) {
            return null;
        }
        double weightSum = 0.0;
        LoadBalancer.Node selectedNode = null;
        LegacyLoadBalancer legacyLoadBalancer = this;
        synchronized (legacyLoadBalancer) {
            for (Mirror.Entry entry : choices) {
                LegacyNodeMetrics nodeMetrics = (LegacyNodeMetrics)this.getNodeMetrics(entry);
                if (!((weightSum += nodeMetrics.weight) > this.position)) continue;
                selectedNode = new LoadBalancer.Node(entry, nodeMetrics);
                break;
            }
            if (selectedNode == null) {
                this.position -= weightSum;
                selectedNode = new LoadBalancer.Node(choices.get(0), this.getNodeMetrics(choices.get(0)));
            }
            this.position += 1.0;
            selectedNode.metrics.incSend();
        }
        return selectedNode;
    }

    @Override
    protected LoadBalancer.NodeMetrics createNodeMetrics() {
        return new LegacyNodeMetrics();
    }

    private void increaseWeights() {
        for (LoadBalancer.NodeMetrics nodeMetrics : this.getNodeWeights()) {
            LegacyNodeMetrics n = (LegacyNodeMetrics)nodeMetrics;
            if (n == null) continue;
            double want = n.weight * 1.0101010101010102;
            n.weight = Math.max(1.0, want);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void received(LoadBalancer.Node node, boolean busy) {
        if (busy) {
            LegacyLoadBalancer legacyLoadBalancer = this;
            synchronized (legacyLoadBalancer) {
                LegacyNodeMetrics n = (LegacyNodeMetrics)node.metrics;
                double wantWeight = n.weight - 0.01;
                if (wantWeight < 1.0) {
                    this.increaseWeights();
                    n.weight = 1.0;
                } else {
                    n.weight = wantWeight;
                }
                node.metrics.incBusy();
            }
        }
    }

    static class LegacyNodeMetrics
    extends LoadBalancer.NodeMetrics {
        double weight = 1.0;

        LegacyNodeMetrics() {
        }
    }
}

