/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.DocumentGet;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.select.DocumentSelector;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.messagebus.protocol.DocumentIgnoredReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.documentapi.messagebus.protocol.DocumentrouteselectorpolicyConfig;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DocumentRouteSelectorPolicy
implements DocumentProtocolRoutingPolicy,
ConfigSubscriber.SingleSubscriber<DocumentrouteselectorpolicyConfig> {
    private static Logger log = Logger.getLogger(DocumentRouteSelectorPolicy.class.getName());
    private Map<String, DocumentSelector> config;
    private String error = "Not configured.";
    private ConfigSubscriber subscriber = new ConfigSubscriber();

    public DocumentRouteSelectorPolicy(String configId) {
        this.subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, DocumentrouteselectorpolicyConfig.class, configId);
    }

    public synchronized String getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(DocumentrouteselectorpolicyConfig cfg) {
        String error = null;
        HashMap<String, DocumentSelector> config = new HashMap<String, DocumentSelector>();
        for (int i = 0; i < cfg.route().size(); ++i) {
            DocumentSelector selector;
            DocumentrouteselectorpolicyConfig.Route route = cfg.route(i);
            if (route.selector().isEmpty()) continue;
            try {
                selector = new DocumentSelector(route.selector());
                log.log(LogLevel.CONFIG, "Selector for route '" + route.name() + "' is '" + selector + "'.");
            }
            catch (ParseException e) {
                error = "Error parsing selector '" + route.selector() + "' for route '" + route.name() + "; " + e.getMessage();
                break;
            }
            config.put(route.name(), selector);
        }
        DocumentRouteSelectorPolicy documentRouteSelectorPolicy = this;
        synchronized (documentRouteSelectorPolicy) {
            this.config = config;
            this.error = error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(RoutingContext context) {
        if (context.getNumRecipients() == 0) {
            context.setError(250002, "No recipients configured.");
            return;
        }
        DocumentRouteSelectorPolicy documentRouteSelectorPolicy = this;
        synchronized (documentRouteSelectorPolicy) {
            if (this.error != null) {
                context.setError(250002, this.error);
                return;
            }
            for (int i = 0; i < context.getNumRecipients(); ++i) {
                Route recipient = context.getRecipient(i);
                String routeName = recipient.toString();
                if (!this.select(context, routeName)) continue;
                Route route = context.getMessageBus().getRoutingTable(DocumentProtocol.NAME).getRoute(routeName);
                context.addChild(route != null ? route : recipient);
            }
        }
        context.setSelectOnRetry(false);
        if (context.getNumChildren() == 0) {
            context.setReply((Reply)new DocumentIgnoredReply());
        }
    }

    private boolean select(RoutingContext context, String routeName) {
        if (this.config == null) {
            return true;
        }
        DocumentSelector selector = this.config.get(routeName);
        if (selector == null) {
            return true;
        }
        Message msg = context.getMessage();
        switch (msg.getType()) {
            case 100004: {
                return selector.accepts((DocumentOperation)((PutDocumentMessage)msg).getDocumentPut()) == Result.TRUE;
            }
            case 100006: {
                return selector.accepts((DocumentOperation)((UpdateDocumentMessage)msg).getDocumentUpdate()) != Result.FALSE;
            }
            case 100005: {
                RemoveDocumentMessage removeMsg = (RemoveDocumentMessage)msg;
                if (removeMsg.getDocumentId().hasDocType()) {
                    return selector.accepts((DocumentOperation)removeMsg.getDocumentRemove()) != Result.FALSE;
                }
                return true;
            }
            case 100003: {
                GetDocumentMessage getMsg = (GetDocumentMessage)msg;
                if (getMsg.getDocumentId().hasDocType()) {
                    DocumentGet getOp = new DocumentGet(getMsg.getDocumentId());
                    return selector.accepts((DocumentOperation)getOp) != Result.FALSE;
                }
                return true;
            }
        }
        return true;
    }

    public void merge(RoutingContext context) {
        DocumentProtocol.merge(context);
    }

    public void destroy() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

