/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExternPolicy
implements DocumentProtocolRoutingPolicy {
    private Supervisor orb = null;
    private Mirror mirror = null;
    private String pattern = null;
    private String session = null;
    private final String error;
    private int offset = 0;
    private int generation = 0;
    private final List<Hop> recipients = new ArrayList<Hop>();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public ExternPolicy(String arg) {
        if (arg == null || arg.length() == 0) {
            this.error = "Expected parameter, got empty string.";
            return;
        }
        String[] args = arg.split(";", 2);
        if (args.length != 2 || args[0].length() == 0 || args[1].length() == 0) {
            this.error = "Expected parameter on the form '<spec>;<pattern>', got '" + arg + "'.";
            return;
        }
        int pos = args[1].lastIndexOf(47);
        if (pos < 0) {
            this.error = "Expected pattern on the form '<service>/<session>', got '" + args[1] + "'.";
            return;
        }
        SlobrokList slobroks = new SlobrokList();
        slobroks.setup(args[0].split(","));
        this.pattern = args[1];
        this.session = this.pattern.substring(pos);
        this.orb = new Supervisor(new Transport());
        this.mirror = new Mirror(this.orb, slobroks);
        this.error = null;
    }

    public String getError() {
        return this.error;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    private synchronized Hop getRecipient() {
        this.update();
        if (this.recipients.isEmpty()) {
            return null;
        }
        int offset = ++this.offset & Integer.MAX_VALUE;
        return new Hop(this.recipients.get(offset % this.recipients.size()));
    }

    private void update() {
        int upd = this.mirror.updates();
        if (this.generation != upd) {
            this.generation = upd;
            this.recipients.clear();
            List arr = this.mirror.lookup(this.pattern);
            for (Mirror.Entry entry : arr) {
                this.recipients.add(Hop.parse((String)(entry.getSpecString() + this.session)));
            }
        }
    }

    public void select(RoutingContext ctx) {
        if (this.error != null) {
            ctx.setError(250002, this.error);
        } else if (this.mirror.ready()) {
            Hop hop = this.getRecipient();
            if (hop != null) {
                Route route = new Route(ctx.getRoute());
                route.setHop(0, hop);
                ctx.addChild(route);
            } else {
                ctx.setError(100002, "Could not resolve any recipients from '" + this.pattern + "'.");
            }
        } else {
            ctx.setError(150000, "Extern slobrok not ready.");
        }
    }

    public void merge(RoutingContext ctx) {
        DocumentProtocol.merge(ctx);
    }

    public void destroy() {
        if (this.destroyed.getAndSet(true)) {
            throw new RuntimeException("Already destroyed");
        }
        this.mirror.shutdown();
        this.orb.transport().shutdown().join();
    }
}

