/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.component.Version;
import com.yahoo.component.VersionSpecification;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentDeserializerFactory;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactory;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.Routable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class RoutableRepository {
    private static final Logger log = Logger.getLogger(RoutableRepository.class.getName());
    private final CopyOnWriteHashMap<Integer, VersionMap> factoryTypes = new CopyOnWriteHashMap();
    private final CopyOnWriteHashMap<CacheKey, RoutableFactory> cache = new CopyOnWriteHashMap();
    private LoadTypeSet loadTypes;

    public RoutableRepository(LoadTypeSet set) {
        this.loadTypes = set;
    }

    Routable decode(DocumentTypeManager docMan, Version version, byte[] data) {
        if (data == null || data.length == 0) {
            log.log((Level)LogLevel.ERROR, "Received empty byte array for deserialization.");
            return null;
        }
        if (version.getMajor() < 5) {
            log.log((Level)LogLevel.ERROR, "Can not decode anything from (version " + version + "). Only major version 5 and up supported.");
            return null;
        }
        DocumentDeserializer in = DocumentDeserializerFactory.createHead((DocumentTypeManager)docMan, (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])data));
        int type = in.getInt(null);
        RoutableFactory factory = this.getFactory(version, type);
        if (factory == null) {
            log.log((Level)LogLevel.ERROR, "No routable factory found for routable type " + type + " (version " + version + ").");
            return null;
        }
        Routable ret = factory.decode(in, this.loadTypes);
        if (ret == null) {
            log.log((Level)LogLevel.ERROR, "Routable factory " + factory.getClass().getName() + " failed to deserialize routable of type " + type + " (version " + version + ").\nData = " + Arrays.toString(data));
            return null;
        }
        return ret;
    }

    byte[] encode(Version version, Routable obj) {
        int type = obj.getType();
        RoutableFactory factory = this.getFactory(version, type);
        if (factory == null) {
            log.log((Level)LogLevel.ERROR, "No routable factory found for routable type " + type + " (version " + version + ").");
            return new byte[0];
        }
        if (version.getMajor() < 5) {
            log.log((Level)LogLevel.ERROR, "Can not encode routable type " + type + " (version " + version + "). Only major version 5 and up supported.");
            return new byte[0];
        }
        DocumentSerializer out = DocumentSerializerFactory.createHead((GrowableByteBuffer)new GrowableByteBuffer(8192));
        out.putInt(null, type);
        if (!factory.encode(obj, out)) {
            log.log((Level)LogLevel.ERROR, "Routable factory " + factory.getClass().getName() + " failed to serialize routable of type " + type + " (version " + version + ").");
            return new byte[0];
        }
        byte[] ret = new byte[out.getBuf().position()];
        out.getBuf().rewind();
        out.getBuf().get(ret);
        return ret;
    }

    void putFactory(VersionSpecification version, int type, RoutableFactory factory) {
        VersionMap versionMap = (VersionMap)this.factoryTypes.get((Object)type);
        if (versionMap == null) {
            versionMap = new VersionMap();
            this.factoryTypes.put((Object)type, (Object)versionMap);
        }
        if (versionMap.putFactory(version, factory)) {
            this.cache.clear();
        }
    }

    private RoutableFactory getFactory(Version version, int type) {
        CacheKey cacheKey = new CacheKey(version, type);
        RoutableFactory factory = (RoutableFactory)this.cache.get((Object)cacheKey);
        if (factory != null) {
            return factory;
        }
        VersionMap versionMap = (VersionMap)this.factoryTypes.get((Object)type);
        if (versionMap == null) {
            return null;
        }
        factory = versionMap.getFactory(version);
        if (factory == null) {
            return null;
        }
        this.cache.put((Object)cacheKey, (Object)factory);
        return factory;
    }

    List<Integer> getRoutableTypes(Version version) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Map.Entry entry : this.factoryTypes.entrySet()) {
            if (((VersionMap)entry.getValue()).getFactory(version) == null) continue;
            ret.add((Integer)entry.getKey());
        }
        return ret;
    }

    private static class CacheKey {
        final Version version;
        final int type;

        CacheKey(Version version, int type) {
            this.version = version;
            this.type = type;
        }

        public int hashCode() {
            return this.version.hashCode() + this.type;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey rhs = (CacheKey)obj;
            if (!this.version.equals((Object)rhs.version)) {
                return false;
            }
            return this.type == rhs.type;
        }
    }

    private static class VersionMap {
        final Map<VersionSpecification, RoutableFactory> factoryVersions = new HashMap<VersionSpecification, RoutableFactory>();

        private VersionMap() {
        }

        boolean putFactory(VersionSpecification version, RoutableFactory factory) {
            return this.factoryVersions.put(version, factory) == null;
        }

        RoutableFactory getFactory(Version version) {
            VersionSpecification versionSpec = version.toSpecification();
            return this.factoryVersions.entrySet().stream().filter(entry -> ((VersionSpecification)entry.getKey()).compareTo(versionSpec) <= 0).max((entry1, entry2) -> ((VersionSpecification)entry1.getKey()).compareTo((VersionSpecification)entry2.getKey())).map(Map.Entry::getValue).orElse(null);
        }
    }
}

