/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

public class Result {
    private Error error = null;
    private long requestId;
    private ResultType type = ResultType.SUCCESS;

    public Result(long requestId) {
        this.requestId = requestId;
    }

    public Result(ResultType type, Error error) {
        this.type = type;
        this.error = error;
    }

    public boolean isSuccess() {
        return this.type == ResultType.SUCCESS;
    }

    public Error getError() {
        return this.error;
    }

    public long getRequestId() {
        return this.requestId;
    }

    @Deprecated
    public ResultType getType() {
        return this.type == ResultType.CONDITION_NOT_MET_ERROR ? ResultType.FATAL_ERROR : this.type;
    }

    public ResultType type() {
        return this.type;
    }

    public static enum ResultType {
        SUCCESS,
        TRANSIENT_ERROR,
        FATAL_ERROR,
        CONDITION_NOT_MET_ERROR;

    }
}

