/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.DocumentId;
import com.yahoo.document.GlobalId;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;

public class DocumentState
implements Comparable<DocumentState> {
    private DocumentId docId;
    private GlobalId gid;
    private long timestamp;
    private boolean removeEntry;

    public DocumentState(DocumentId docId, long timestamp, boolean removeEntry) {
        this.docId = docId;
        this.gid = new GlobalId(docId.getGlobalId());
        this.timestamp = timestamp;
        this.removeEntry = removeEntry;
    }

    public DocumentState(GlobalId gid, long timestamp, boolean removeEntry) {
        this.gid = gid;
        this.timestamp = timestamp;
        this.removeEntry = removeEntry;
    }

    public DocumentState(Deserializer buf) {
        byte hasDocId = buf.getByte(null);
        if (hasDocId == 1) {
            this.docId = new DocumentId(buf);
        }
        this.gid = new GlobalId(buf);
        this.timestamp = buf.getLong(null);
        this.removeEntry = buf.getByte(null) > 0;
    }

    public DocumentId getDocId() {
        return this.docId;
    }

    public GlobalId getGid() {
        return this.gid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isRemoveEntry() {
        return this.removeEntry;
    }

    public void serialize(Serializer buf) {
        if (this.docId != null) {
            buf.putByte(null, (byte)1);
            this.docId.serialize(buf);
        } else {
            buf.putByte(null, (byte)0);
        }
        this.gid.serialize(buf);
        buf.putLong(null, this.timestamp);
        buf.putByte(null, (byte)(this.removeEntry ? 1 : 0));
    }

    public int getSerializedSize() {
        int size = 0;
        if (this.docId != null) {
            size += Utf8.byteCount((CharSequence)this.docId.toString()) + 1;
        }
        size += 12;
        size += 8;
        return ++size;
    }

    @Override
    public int compareTo(DocumentState state) {
        int comp = this.gid.compareTo((Object)state.gid);
        if (comp == 0) {
            if (this.docId != null) {
                if (state.docId != null) {
                    return this.docId.toString().compareTo(state.docId.toString());
                }
                return 1;
            }
            if (state.docId != null) {
                return -1;
            }
        }
        return comp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentState)) {
            return false;
        }
        DocumentState that = (DocumentState)o;
        if (this.removeEntry != that.removeEntry) {
            return false;
        }
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.docId != null ? !this.docId.equals((Object)that.docId) : that.docId != null) {
            return false;
        }
        return this.gid.equals((Object)that.gid);
    }

    public int hashCode() {
        int result = this.docId != null ? this.docId.hashCode() : 0;
        result = 31 * result + this.gid.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.removeEntry ? 1 : 0);
        return result;
    }

    public String toString() {
        return "DocumentState{docId=" + this.docId + ", gid=" + this.gid + ", timestamp=" + this.timestamp + ", removeEntry=" + this.removeEntry + '}';
    }
}

