/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.systemstate.parser;

import com.yahoo.documentapi.messagebus.systemstate.parser.SimpleCharStream;
import com.yahoo.documentapi.messagebus.systemstate.parser.StateParserConstants;
import com.yahoo.documentapi.messagebus.systemstate.parser.Token;
import com.yahoo.documentapi.messagebus.systemstate.parser.TokenMgrError;
import java.io.IOException;
import java.io.PrintStream;

public class StateParserTokenManager
implements StateParserConstants {
    public PrintStream debugStream = System.out;
    static final int[] jjnextStates = new int[0];
    public static final String[] jjstrLiteralImages = new String[]{"", null, "/", "..", ".", "?", "&", "=", null, null, null, null};
    public static final String[] lexStateNames = new String[]{"DEFAULT"};
    protected SimpleCharStream input_stream;
    private final int[] jjrounds = new int[5];
    private final int[] jjstateSet = new int[10];
    protected char curChar;
    int curLexState = 0;
    int defaultLexState = 0;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;

    public void setDebugStream(PrintStream ds) {
        this.debugStream = ds;
    }

    private final int jjStopStringLiteralDfa_0(int pos, long active0) {
        switch (pos) {
            case 0: {
                if ((active0 & 0x18L) != 0L) {
                    return 5;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_0(int pos, long active0) {
        return this.jjMoveNfa_0(this.jjStopStringLiteralDfa_0(pos, active0), pos + 1);
    }

    private int jjStopAtPos(int pos, int kind) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        return pos + 1;
    }

    private int jjMoveStringLiteralDfa0_0() {
        switch (this.curChar) {
            case '&': {
                return this.jjStopAtPos(0, 6);
            }
            case '.': {
                this.jjmatchedKind = 4;
                return this.jjMoveStringLiteralDfa1_0(8L);
            }
            case '/': {
                return this.jjStopAtPos(0, 2);
            }
            case '=': {
                return this.jjStopAtPos(0, 7);
            }
            case '?': {
                return this.jjStopAtPos(0, 5);
            }
        }
        return this.jjMoveNfa_0(0, 0);
    }

    private int jjMoveStringLiteralDfa1_0(long active0) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(0, active0);
            return 1;
        }
        switch (this.curChar) {
            case '.': {
                if ((active0 & 8L) == 0L) break;
                return this.jjStartNfaWithStates_0(1, 3, 5);
            }
        }
        return this.jjStartNfa_0(0, active0);
    }

    private int jjStartNfaWithStates_0(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_0(state, pos + 1);
    }

    private int jjMoveNfa_0(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 5;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                long l = 1L << this.curChar;
                block19: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x3FF680000000000L & l) != 0L) {
                                if (kind > 8) {
                                    kind = 8;
                                }
                                this.jjCheckNAddTwoStates(1, 2);
                                break;
                            }
                            if ((0x100003600L & l) != 0L) {
                                if (kind <= 1) break;
                                kind = 1;
                                break;
                            }
                            if (this.curChar != '%') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 3;
                            break;
                        }
                        case 5: {
                            if ((0x3FF680000000000L & l) != 0L) {
                                if (kind > 8) {
                                    kind = 8;
                                }
                                this.jjCheckNAddTwoStates(1, 2);
                                break;
                            }
                            if (this.curChar != '%') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 3;
                            break;
                        }
                        case 1: {
                            if ((0x3FF680000000000L & l) == 0L) continue block19;
                            if (kind > 8) {
                                kind = 8;
                            }
                            this.jjCheckNAddTwoStates(1, 2);
                            break;
                        }
                        case 2: {
                            if (this.curChar != '%') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 3;
                            break;
                        }
                        case 3: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 4: {
                            if ((0x3FF000000000000L & l) == 0L) continue block19;
                            if (kind > 8) {
                                kind = 8;
                            }
                            this.jjCheckNAddTwoStates(1, 2);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                long l = 1L << (this.curChar & 0x3F);
                block20: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 1: {
                            if ((0x47FFFFFE87FFFFFEL & l) == 0L) continue block20;
                            if (kind > 8) {
                                kind = 8;
                            }
                            this.jjCheckNAddTwoStates(1, 2);
                            break;
                        }
                        case 5: {
                            if ((0x47FFFFFE87FFFFFEL & l) == 0L) continue block20;
                            if (kind > 8) {
                                kind = 8;
                            }
                            this.jjCheckNAddTwoStates(1, 2);
                            break;
                        }
                        case 3: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 4: {
                            if ((0x7E0000007EL & l) == 0L) continue block20;
                            if (kind > 8) {
                                kind = 8;
                            }
                            this.jjCheckNAddTwoStates(1, 2);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                do {
                    switch (this.jjstateSet[--i]) {
                        default: 
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 5 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    public StateParserTokenManager(SimpleCharStream stream) {
        this.input_stream = stream;
    }

    public StateParserTokenManager(SimpleCharStream stream, int lexState) {
        this(stream);
        this.SwitchTo(lexState);
    }

    public void ReInit(SimpleCharStream stream) {
        this.jjnewStateCnt = 0;
        this.jjmatchedPos = 0;
        this.curLexState = this.defaultLexState;
        this.input_stream = stream;
        this.ReInitRounds();
    }

    private void ReInitRounds() {
        this.jjround = -2147483647;
        int i = 5;
        while (i-- > 0) {
            this.jjrounds[i] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(SimpleCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void SwitchTo(int lexState) {
        if (lexState >= 1 || lexState < 0) {
            throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", 2);
        }
        this.curLexState = lexState;
    }

    protected Token jjFillToken() {
        String im = jjstrLiteralImages[this.jjmatchedKind];
        String curTokenImage = im == null ? this.input_stream.GetImage() : im;
        int beginLine = this.input_stream.getBeginLine();
        int beginColumn = this.input_stream.getBeginColumn();
        int endLine = this.input_stream.getEndLine();
        int endColumn = this.input_stream.getEndColumn();
        Token t = Token.newToken(this.jjmatchedKind, curTokenImage);
        t.beginLine = beginLine;
        t.endLine = endLine;
        t.beginColumn = beginColumn;
        t.endColumn = endColumn;
        return t;
    }

    public Token getNextToken() {
        int curPos = 0;
        try {
            this.curChar = this.input_stream.BeginToken();
        }
        catch (IOException e) {
            this.jjmatchedKind = 0;
            Token matchedToken = this.jjFillToken();
            return matchedToken;
        }
        this.jjmatchedKind = Integer.MAX_VALUE;
        this.jjmatchedPos = 0;
        curPos = this.jjMoveStringLiteralDfa0_0();
        if (this.jjmatchedKind != Integer.MAX_VALUE) {
            if (this.jjmatchedPos + 1 < curPos) {
                this.input_stream.backup(curPos - this.jjmatchedPos - 1);
            }
            Token matchedToken = this.jjFillToken();
            return matchedToken;
        }
        int error_line = this.input_stream.getEndLine();
        int error_column = this.input_stream.getEndColumn();
        String error_after = null;
        boolean EOFSeen = false;
        try {
            this.input_stream.readChar();
            this.input_stream.backup(1);
        }
        catch (IOException e1) {
            EOFSeen = true;
            String string = error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
            if (this.curChar == '\n' || this.curChar == '\r') {
                ++error_line;
                error_column = 0;
            }
            ++error_column;
        }
        if (!EOFSeen) {
            this.input_stream.backup(1);
            error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
        }
        throw new TokenMgrError(EOFSeen, this.curLexState, error_line, error_column, error_after, this.curChar, 0);
    }

    private void jjCheckNAdd(int state) {
        if (this.jjrounds[state] != this.jjround) {
            this.jjstateSet[this.jjnewStateCnt++] = state;
            this.jjrounds[state] = this.jjround;
        }
    }

    private void jjAddStates(int start, int end) {
        do {
            this.jjstateSet[this.jjnewStateCnt++] = jjnextStates[start];
        } while (start++ != end);
    }

    private void jjCheckNAddTwoStates(int state1, int state2) {
        this.jjCheckNAdd(state1);
        this.jjCheckNAdd(state2);
    }
}

