/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.google.common.annotations.Beta;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.Version;
import com.yahoo.component.VersionSpecification;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.documentapi.messagebus.protocol.ReplyMerger;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories50;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories51;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories52;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories60;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactory;
import com.yahoo.documentapi.messagebus.protocol.RoutableRepository;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactories;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyFactory;
import com.yahoo.documentapi.messagebus.protocol.RoutingPolicyRepository;
import com.yahoo.documentapi.metrics.DocumentProtocolMetricSet;
import com.yahoo.messagebus.ErrorCode;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import com.yahoo.messagebus.routing.RoutingPolicy;
import com.yahoo.text.Utf8String;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class DocumentProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(DocumentProtocol.class.getName());
    private final DocumentProtocolMetricSet metrics = new DocumentProtocolMetricSet();
    private final RoutingPolicyRepository routingPolicyRepository = new RoutingPolicyRepository(this.metrics);
    private final RoutableRepository routableRepository;
    private final DocumentTypeManager docMan;
    public static final Utf8String NAME = new Utf8String("document");
    public static final int DOCUMENT_MESSAGE = 100000;
    public static final int MESSAGE_GETDOCUMENT = 100003;
    public static final int MESSAGE_PUTDOCUMENT = 100004;
    public static final int MESSAGE_REMOVEDOCUMENT = 100005;
    public static final int MESSAGE_UPDATEDOCUMENT = 100006;
    public static final int MESSAGE_CREATEVISITOR = 100007;
    public static final int MESSAGE_DESTROYVISITOR = 100008;
    public static final int MESSAGE_VISITORINFO = 100009;
    public static final int MESSAGE_SEARCHRESULT = 100011;
    public static final int MESSAGE_DOCUMENTSUMMARY = 100014;
    public static final int MESSAGE_MAPVISITOR = 100015;
    public static final int MESSAGE_GETBUCKETSTATE = 100018;
    public static final int MESSAGE_STATBUCKET = 100019;
    public static final int MESSAGE_GETBUCKETLIST = 100020;
    public static final int MESSAGE_DOCUMENTLIST = 100021;
    public static final int MESSAGE_EMPTYBUCKETS = 100023;
    public static final int MESSAGE_REMOVELOCATION = 100024;
    public static final int MESSAGE_QUERYRESULT = 100025;
    public static final int MESSAGE_BATCHDOCUMENTUPDATE = 100026;
    public static final int DOCUMENT_REPLY = 200000;
    public static final int REPLY_GETDOCUMENT = 200003;
    public static final int REPLY_PUTDOCUMENT = 200004;
    public static final int REPLY_REMOVEDOCUMENT = 200005;
    public static final int REPLY_UPDATEDOCUMENT = 200006;
    public static final int REPLY_CREATEVISITOR = 200007;
    public static final int REPLY_DESTROYVISITOR = 200008;
    public static final int REPLY_VISITORINFO = 200009;
    public static final int REPLY_SEARCHRESULT = 200011;
    public static final int REPLY_DOCUMENTSUMMARY = 200014;
    public static final int REPLY_MAPVISITOR = 200015;
    public static final int REPLY_GETBUCKETSTATE = 200018;
    public static final int REPLY_STATBUCKET = 200019;
    public static final int REPLY_GETBUCKETLIST = 200020;
    public static final int REPLY_DOCUMENTLIST = 200021;
    public static final int REPLY_EMPTYBUCKETS = 200023;
    public static final int REPLY_REMOVELOCATION = 200024;
    public static final int REPLY_QUERYRESULT = 200025;
    public static final int REPLY_BATCHDOCUMENTUPDATE = 200026;
    public static final int REPLY_WRONGDISTRIBUTION = 201000;
    public static final int REPLY_DOCUMENTIGNORED = 201001;
    public static final int ERROR_MESSAGE_IGNORED = 250001;
    public static final int ERROR_POLICY_FAILURE = 250002;
    public static final int ERROR_DOCUMENT_NOT_FOUND = 251001;
    public static final int ERROR_DOCUMENT_EXISTS = 251002;
    public static final int ERROR_NOT_IMPLEMENTED = 251004;
    public static final int ERROR_ILLEGAL_PARAMETERS = 251005;
    public static final int ERROR_UNKNOWN_COMMAND = 251007;
    public static final int ERROR_UNPARSEABLE = 251008;
    public static final int ERROR_NO_SPACE = 251009;
    public static final int ERROR_IGNORED = 251010;
    public static final int ERROR_INTERNAL_FAILURE = 251011;
    public static final int ERROR_REJECTED = 251012;
    @Beta
    public static final int ERROR_TEST_AND_SET_CONDITION_FAILED = 251013;
    public static final int ERROR_PROCESSING_FAILURE = 252001;
    public static final int ERROR_TIMESTAMP_EXIST = 252002;
    public static final int ERROR_NODE_NOT_READY = 151001;
    public static final int ERROR_WRONG_DISTRIBUTION = 151002;
    public static final int ERROR_ABORTED = 151004;
    public static final int ERROR_BUSY = 151005;
    public static final int ERROR_NOT_CONNECTED = 151006;
    public static final int ERROR_DISK_FAILURE = 151007;
    public static final int ERROR_IO_FAILURE = 151008;
    public static final int ERROR_BUCKET_NOT_FOUND = 151009;
    public static final int ERROR_BUCKET_DELETED = 151012;
    public static final int ERROR_STALE_TIMESTAMP = 151013;
    public static final int ERROR_SUSPENDED = 152001;

    public static Priority getPriority(int val) {
        for (Priority pri : Priority.values()) {
            if (val != pri.val) continue;
            return pri;
        }
        throw new IllegalArgumentException("Unknown priority: " + val);
    }

    public static Priority getPriorityByName(String name) {
        return Priority.valueOf(name);
    }

    public DocumentProtocol(DocumentTypeManager docMan) {
        this(docMan, null, new LoadTypeSet());
    }

    public DocumentProtocol(DocumentTypeManager docMan, String configId) {
        this(docMan, configId, new LoadTypeSet());
    }

    public DocumentProtocol(DocumentTypeManager docMan, String configId, LoadTypeSet set) {
        String cfg;
        String string = cfg = configId == null ? "client" : configId;
        if (docMan != null) {
            this.docMan = docMan;
        } else {
            this.docMan = new DocumentTypeManager();
            DocumentTypeManagerConfigurer.configure((DocumentTypeManager)this.docMan, (String)cfg);
        }
        this.routableRepository = new RoutableRepository(set);
        this.putRoutingPolicyFactory("AND", new RoutingPolicyFactories.AndPolicyFactory());
        this.putRoutingPolicyFactory("Content", new RoutingPolicyFactories.ContentPolicyFactory());
        this.putRoutingPolicyFactory("DocumentRouteSelector", new RoutingPolicyFactories.DocumentRouteSelectorPolicyFactory(cfg));
        this.putRoutingPolicyFactory("Extern", new RoutingPolicyFactories.ExternPolicyFactory());
        this.putRoutingPolicyFactory("LocalService", new RoutingPolicyFactories.LocalServicePolicyFactory());
        this.putRoutingPolicyFactory("MessageType", new RoutingPolicyFactories.MessageTypePolicyFactory(cfg));
        this.putRoutingPolicyFactory("RoundRobin", new RoutingPolicyFactories.RoundRobinPolicyFactory());
        this.putRoutingPolicyFactory("LoadBalancer", new RoutingPolicyFactories.LoadBalancerPolicyFactory());
        this.putRoutingPolicyFactory("Storage", new RoutingPolicyFactories.StoragePolicyFactory());
        this.putRoutingPolicyFactory("SubsetService", new RoutingPolicyFactories.SubsetServicePolicyFactory());
        VersionSpecification version50 = new VersionSpecification(Integer.valueOf(5), Integer.valueOf(0));
        VersionSpecification version51 = new VersionSpecification(Integer.valueOf(5), Integer.valueOf(1));
        VersionSpecification version52 = new VersionSpecification(Integer.valueOf(5), Integer.valueOf(115));
        VersionSpecification version6 = new VersionSpecification(Integer.valueOf(6), Integer.valueOf(221));
        List<VersionSpecification> from50 = Arrays.asList(version50, version51, version52, version6);
        List<VersionSpecification> from51 = Arrays.asList(version51, version52, version6);
        List<VersionSpecification> from52 = Arrays.asList(version52, version6);
        List<VersionSpecification> from6 = Collections.singletonList(version6);
        this.putRoutableFactory(100026, (RoutableFactory)new RoutableFactories50.BatchDocumentUpdateMessageFactory(), from50);
        this.putRoutableFactory(100007, (RoutableFactory)new RoutableFactories50.CreateVisitorMessageFactory(), from50);
        this.putRoutableFactory(100008, (RoutableFactory)new RoutableFactories50.DestroyVisitorMessageFactory(), from50);
        this.putRoutableFactory(100021, (RoutableFactory)new RoutableFactories50.DocumentListMessageFactory(), from50);
        this.putRoutableFactory(100014, (RoutableFactory)new RoutableFactories50.DocumentSummaryMessageFactory(), from50);
        this.putRoutableFactory(100023, (RoutableFactory)new RoutableFactories50.EmptyBucketsMessageFactory(), from50);
        this.putRoutableFactory(100020, (RoutableFactory)new RoutableFactories50.GetBucketListMessageFactory(), from50);
        this.putRoutableFactory(100018, (RoutableFactory)new RoutableFactories50.GetBucketStateMessageFactory(), from50);
        this.putRoutableFactory(100003, (RoutableFactory)new RoutableFactories50.GetDocumentMessageFactory(), from50);
        this.putRoutableFactory(100015, (RoutableFactory)new RoutableFactories50.MapVisitorMessageFactory(), from50);
        this.putRoutableFactory(100004, (RoutableFactory)new RoutableFactories50.PutDocumentMessageFactory(), from50);
        this.putRoutableFactory(100025, (RoutableFactory)new RoutableFactories50.QueryResultMessageFactory(), from50);
        this.putRoutableFactory(100005, (RoutableFactory)new RoutableFactories50.RemoveDocumentMessageFactory(), from50);
        this.putRoutableFactory(100024, (RoutableFactory)new RoutableFactories50.RemoveLocationMessageFactory(), from50);
        this.putRoutableFactory(100011, (RoutableFactory)new RoutableFactories50.SearchResultMessageFactory(), from50);
        this.putRoutableFactory(100019, (RoutableFactory)new RoutableFactories50.StatBucketMessageFactory(), from50);
        this.putRoutableFactory(100006, (RoutableFactory)new RoutableFactories50.UpdateDocumentMessageFactory(), from50);
        this.putRoutableFactory(100009, (RoutableFactory)new RoutableFactories50.VisitorInfoMessageFactory(), from50);
        this.putRoutableFactory(200026, (RoutableFactory)new RoutableFactories50.BatchDocumentUpdateReplyFactory(), from50);
        this.putRoutableFactory(200007, (RoutableFactory)new RoutableFactories50.CreateVisitorReplyFactory(), from50);
        this.putRoutableFactory(200008, (RoutableFactory)new RoutableFactories50.DestroyVisitorReplyFactory(), from50);
        this.putRoutableFactory(200021, (RoutableFactory)new RoutableFactories50.DocumentListReplyFactory(), from50);
        this.putRoutableFactory(200014, (RoutableFactory)new RoutableFactories50.DocumentSummaryReplyFactory(), from50);
        this.putRoutableFactory(200023, (RoutableFactory)new RoutableFactories50.EmptyBucketsReplyFactory(), from50);
        this.putRoutableFactory(200020, (RoutableFactory)new RoutableFactories50.GetBucketListReplyFactory(), from50);
        this.putRoutableFactory(200018, (RoutableFactory)new RoutableFactories50.GetBucketStateReplyFactory(), from50);
        this.putRoutableFactory(200003, (RoutableFactory)new RoutableFactories50.GetDocumentReplyFactory(), from50);
        this.putRoutableFactory(200015, (RoutableFactory)new RoutableFactories50.MapVisitorReplyFactory(), from50);
        this.putRoutableFactory(200004, (RoutableFactory)new RoutableFactories50.PutDocumentReplyFactory(), from50);
        this.putRoutableFactory(200025, (RoutableFactory)new RoutableFactories50.QueryResultReplyFactory(), from50);
        this.putRoutableFactory(200005, (RoutableFactory)new RoutableFactories50.RemoveDocumentReplyFactory(), from50);
        this.putRoutableFactory(200024, (RoutableFactory)new RoutableFactories50.RemoveLocationReplyFactory(), from50);
        this.putRoutableFactory(200011, (RoutableFactory)new RoutableFactories50.SearchResultReplyFactory(), from50);
        this.putRoutableFactory(200019, (RoutableFactory)new RoutableFactories50.StatBucketReplyFactory(), from50);
        this.putRoutableFactory(200006, (RoutableFactory)new RoutableFactories50.UpdateDocumentReplyFactory(), from50);
        this.putRoutableFactory(200006, (RoutableFactory)new RoutableFactories50.UpdateDocumentReplyFactory(), from50);
        this.putRoutableFactory(200009, (RoutableFactory)new RoutableFactories50.VisitorInfoReplyFactory(), from50);
        this.putRoutableFactory(201000, (RoutableFactory)new RoutableFactories50.WrongDistributionReplyFactory(), from50);
        this.putRoutableFactory(100007, (RoutableFactory)new RoutableFactories51.CreateVisitorMessageFactory(), from51);
        this.putRoutableFactory(100003, (RoutableFactory)new RoutableFactories51.GetDocumentMessageFactory(), from51);
        this.putRoutableFactory(201001, (RoutableFactory)new RoutableFactories51.DocumentIgnoredReplyFactory(), from51);
        this.putRoutableFactory(100004, (RoutableFactory)new RoutableFactories52.PutDocumentMessageFactory(), from52);
        this.putRoutableFactory(100006, (RoutableFactory)new RoutableFactories52.UpdateDocumentMessageFactory(), from52);
        this.putRoutableFactory(100005, (RoutableFactory)new RoutableFactories52.RemoveDocumentMessageFactory(), from52);
        this.putRoutableFactory(100007, (RoutableFactory)new RoutableFactories60.CreateVisitorMessageFactory(), from6);
        this.putRoutableFactory(100019, (RoutableFactory)new RoutableFactories60.StatBucketMessageFactory(), from6);
        this.putRoutableFactory(100020, (RoutableFactory)new RoutableFactories60.GetBucketListMessageFactory(), from6);
    }

    public DocumentProtocol putRoutingPolicyFactory(String name, RoutingPolicyFactory factory) {
        this.routingPolicyRepository.putFactory(name, factory);
        return this;
    }

    public DocumentProtocol putRoutableFactory(int type, RoutableFactory factory, VersionSpecification version) {
        this.routableRepository.putFactory(version, type, factory);
        return this;
    }

    public DocumentProtocol putRoutableFactory(int type, RoutableFactory factory, List<VersionSpecification> versions) {
        for (VersionSpecification version : versions) {
            this.putRoutableFactory(type, factory, version);
        }
        return this;
    }

    public static String getErrorName(int code) {
        switch (code) {
            case 250001: {
                return "MESSAGE_IGNORED";
            }
            case 250002: {
                return "POLICY_FAILURE";
            }
            case 251001: {
                return "DOCUMENT_NOT_FOUND";
            }
            case 251002: {
                return "DOCUMENT_EXISTS";
            }
            case 151009: {
                return "BUCKET_NOT_FOUND";
            }
            case 151012: {
                return "BUCKET_DELETED";
            }
            case 251004: {
                return "NOT_IMPLEMENTED";
            }
            case 251005: {
                return "ILLEGAL_PARAMETERS";
            }
            case 251010: {
                return "IGNORED";
            }
            case 251007: {
                return "UNKNOWN_COMMAND";
            }
            case 251008: {
                return "UNPARSEABLE";
            }
            case 251009: {
                return "NO_SPACE";
            }
            case 251011: {
                return "INTERNAL_FAILURE";
            }
            case 252001: {
                return "PROCESSING_FAILURE";
            }
            case 252002: {
                return "TIMESTAMP_EXIST";
            }
            case 151013: {
                return "STALE_TIMESTAMP";
            }
            case 151001: {
                return "NODE_NOT_READY";
            }
            case 151002: {
                return "WRONG_DISTRIBUTION";
            }
            case 251012: {
                return "REJECTED";
            }
            case 151004: {
                return "ABORTED";
            }
            case 151005: {
                return "BUSY";
            }
            case 151006: {
                return "NOT_CONNECTED";
            }
            case 151007: {
                return "DISK_FAILURE";
            }
            case 151008: {
                return "IO_FAILURE";
            }
            case 152001: {
                return "SUSPENDED";
            }
            case 251013: {
                return "TEST_AND_SET_CONDITION_FAILED";
            }
        }
        return ErrorCode.getName((int)code);
    }

    public static void merge(RoutingContext ctx) {
        DocumentProtocol.merge(ctx, new HashSet<Integer>(0));
    }

    public static void merge(RoutingContext ctx, Set<Integer> mask) {
        LinkedList<Reply> replies = new LinkedList<Reply>();
        RoutingNodeIterator it = ctx.getChildIterator();
        while (it.isValid()) {
            Reply ref = it.getReplyRef();
            replies.add(ref);
            it.next();
        }
        Tuple2<Integer, Reply> tuple = DocumentProtocol.merge(replies, mask);
        if (tuple.first != null) {
            ctx.getChildIterator().skip(((Integer)tuple.first).intValue()).removeReply();
        }
        ctx.setReply((Reply)tuple.second);
    }

    private static Tuple2<Integer, Reply> merge(List<Reply> replies, Set<Integer> mask) {
        ReplyMerger rm = new ReplyMerger();
        for (int i = 0; i < replies.size(); ++i) {
            if (mask.contains(i)) continue;
            rm.merge(i, replies.get(i));
        }
        return rm.mergedReply();
    }

    public static Reply merge(List<Reply> replies) {
        return (Reply)DocumentProtocol.merge(replies, new HashSet<Integer>((int)0)).second;
    }

    public static boolean hasOnlyErrorsOfType(Reply reply, int errCode) {
        if (!reply.hasErrors()) {
            return false;
        }
        for (int i = 0; i < reply.getNumErrors(); ++i) {
            if (reply.getError(i).getCode() == errCode) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NAME.toString();
    }

    public RoutingPolicy createPolicy(String name, String param) {
        return this.routingPolicyRepository.createPolicy(name, param);
    }

    public byte[] encode(Version version, Routable routable) {
        return this.routableRepository.encode(version, routable);
    }

    public Routable decode(Version version, byte[] data) {
        try {
            return this.routableRepository.decode(this.docMan, version, data);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.warning(e.getMessage());
            return null;
        }
    }

    public List<Integer> getRoutableTypes(Version version) {
        return this.routableRepository.getRoutableTypes(version);
    }

    public MetricSet getMetrics() {
        return this.metrics;
    }

    public final DocumentTypeManager getDocumentTypeManager() {
        return this.docMan;
    }

    public static enum Priority {
        HIGHEST(0),
        VERY_HIGH(1),
        HIGH_1(2),
        HIGH_2(3),
        HIGH_3(4),
        NORMAL_1(5),
        NORMAL_2(6),
        NORMAL_3(7),
        NORMAL_4(8),
        NORMAL_5(9),
        NORMAL_6(10),
        LOW_1(11),
        LOW_2(12),
        LOW_3(13),
        VERY_LOW(14),
        LOWEST(15);

        private final int val;

        private Priority(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

