/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.vespa.config.content.MessagetyperouteselectorpolicyConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class MessageTypePolicy
implements DocumentProtocolRoutingPolicy,
ConfigSubscriber.SingleSubscriber<MessagetyperouteselectorpolicyConfig> {
    private final AtomicReference<Map<Integer, Route>> configRef = new AtomicReference();
    private ConfigSubscriber subscriber = new ConfigSubscriber();
    private volatile Route defaultRoute;

    public MessageTypePolicy(String configId) {
        this.subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, MessagetyperouteselectorpolicyConfig.class, configId);
    }

    public void select(RoutingContext context) {
        int messageType = context.getMessage().getType();
        Route route = this.configRef.get().get(messageType);
        if (route == null) {
            route = this.defaultRoute;
        }
        context.addChild(route);
    }

    public void merge(RoutingContext context) {
        DocumentProtocol.merge(context);
    }

    public void destroy() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }

    @Override
    public MetricSet getMetrics() {
        return null;
    }

    public void configure(MessagetyperouteselectorpolicyConfig cfg) {
        HashMap<Integer, Route> h = new HashMap<Integer, Route>();
        for (MessagetyperouteselectorpolicyConfig.Route selector : cfg.route()) {
            h.put(selector.messagetype(), Route.parse((String)selector.name()));
        }
        this.configRef.set(h);
        this.defaultRoute = Route.parse((String)cfg.defaultroute());
    }
}

