/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocolRoutingPolicy;
import com.yahoo.messagebus.metrics.MetricSet;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import java.util.ArrayList;
import java.util.List;

public class ANDPolicy
implements DocumentProtocolRoutingPolicy {
    private final List<Hop> hops = new ArrayList<Hop>();

    public ANDPolicy(String param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        Route route = Route.parse((String)param);
        for (int i = 0; i < route.getNumHops(); ++i) {
            this.hops.add(route.getHop(i));
        }
    }

    public void select(RoutingContext context) {
        if (this.hops.isEmpty()) {
            context.addChildren(context.getAllRecipients());
        } else {
            for (Hop hop : this.hops) {
                Route route = new Route(context.getRoute());
                route.setHop(0, hop);
                context.addChild(route);
            }
        }
        context.setSelectOnRetry(false);
        context.addConsumableError(250001);
    }

    public void merge(RoutingContext context) {
        DocumentProtocol.merge(context);
    }

    public void destroy() {
    }

    @Override
    public MetricSet getMetrics() {
        return null;
    }
}

