/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.AnnotationType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotationTypeRegistry {
    private final Map<Integer, AnnotationType> idMap = new HashMap<Integer, AnnotationType>();
    private final Map<String, AnnotationType> nameMap = new HashMap<String, AnnotationType>();

    public void register(AnnotationType type) {
        if (this.idMap.containsKey(type.getId()) || this.nameMap.containsKey(type.getName())) {
            AnnotationType idType = this.idMap.get(type.getId());
            AnnotationType nameType = this.nameMap.get(type.getName());
            if (type.equals(idType) && type.equals(nameType)) {
                return;
            }
            throw new IllegalArgumentException("A type is already registered with this name or this id.");
        }
        this.idMap.put(type.getId(), type);
        this.nameMap.put(type.getName(), type);
    }

    public boolean unregister(String name) {
        AnnotationType oldType = this.nameMap.remove(name);
        if (oldType != null) {
            this.idMap.remove(oldType.getId());
            return true;
        }
        return false;
    }

    public boolean unregister(int id) {
        AnnotationType oldType = this.idMap.remove(id);
        if (oldType != null) {
            this.nameMap.remove(oldType.getName());
            return true;
        }
        return false;
    }

    public boolean unregister(AnnotationType type) {
        if (this.idMap.containsKey(type.getId()) && this.nameMap.containsKey(type.getName())) {
            AnnotationType nameType;
            AnnotationType idType = this.idMap.get(type.getId());
            if (idType != (nameType = this.nameMap.get(type.getName()))) {
                throw new IllegalArgumentException("The ID and name of this annotation type are present, but they do not belong together. Not removing type.");
            }
            this.idMap.remove(type.getId());
            this.nameMap.remove(type.getName());
            return true;
        }
        return false;
    }

    public AnnotationType getType(String name) {
        return this.nameMap.get(name);
    }

    public AnnotationType getType(int id) {
        return this.idMap.get(id);
    }

    public Map<String, AnnotationType> getTypes() {
        return Collections.unmodifiableMap(this.nameMap);
    }

    public void clear() {
        this.idMap.clear();
        this.nameMap.clear();
    }
}

