/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.collections.CollectionComparator;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.annotation.internal.SimpleIndexingAnnotations;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.text.Text;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class StringFieldValue
extends FieldValue {
    private static final Logger log = Logger.getLogger(StringFieldValue.class.getName());
    private static final boolean replaceInvalidUnicode = System.getProperty("vespa.replace_invalid_unicode", "false").equals("true");
    public static final int classId = StringFieldValue.registerClass((int)4111, StringFieldValue.class);
    private String value;
    private Map<String, SpanTree> spanTrees = null;
    private SimpleIndexingAnnotations simpleAnnotations = null;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public StringFieldValue() {
        this.value = "";
    }

    public StringFieldValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.setValue(value);
    }

    private static String validateTextString(String value) {
        if (!Text.isValidTextString((String)value)) {
            if (replaceInvalidUnicode) {
                return Text.stripInvalidCharacters((String)value);
            }
            throw new IllegalArgumentException("The string field value contains illegal code point 0x" + Integer.toHexString(Text.validateTextString((String)value).getAsInt()).toUpperCase());
        }
        return value;
    }

    private void setValue(String value) {
        this.value = StringFieldValue.validateTextString(value);
    }

    private AnnotationMode getAnnotationMode() {
        boolean hasFull;
        boolean hasSimple = this.simpleAnnotations != null;
        boolean bl = hasFull = this.spanTrees != null;
        if (hasSimple && hasFull) {
            throw new IllegalStateException("Invariant violation: Both simple and full annotations exist! simpleAnnotations.count=" + this.simpleAnnotations.getCount() + ", spanTrees.size=" + this.spanTrees.size());
        }
        if (hasSimple) {
            return AnnotationMode.SIMPLE;
        }
        if (hasFull) {
            return AnnotationMode.FULL;
        }
        return AnnotationMode.NONE;
    }

    private void assertInvariant() {
        this.getAnnotationMode();
    }

    private void changeAnnotationMode(AnnotationMode targetMode) {
        AnnotationMode currentMode = this.getAnnotationMode();
        if (currentMode == targetMode) {
            return;
        }
        switch (targetMode) {
            case NONE: {
                this.simpleAnnotations = null;
                if (this.spanTrees == null) break;
                this.spanTrees.clear();
                this.spanTrees = null;
                break;
            }
            case SIMPLE: {
                if (currentMode == AnnotationMode.FULL) {
                    throw new IllegalStateException("Cannot convert from FULL to SIMPLE annotation mode");
                }
                this.simpleAnnotations = new SimpleIndexingAnnotations();
                break;
            }
            case FULL: {
                if (currentMode == AnnotationMode.SIMPLE) {
                    log.warning("Converting from SIMPLE to FULL annotation mode - this may indicate inefficient code path");
                    this.spanTrees = new HashMap<String, SpanTree>(1);
                    SpanTree tree = this.simpleAnnotations.toSpanTree("linguistics");
                    tree.setStringFieldValue(this);
                    this.spanTrees.put("linguistics", tree);
                    this.simpleAnnotations = null;
                    break;
                }
                if (currentMode != AnnotationMode.NONE || this.spanTrees != null) break;
                this.spanTrees = new HashMap<String, SpanTree>(1);
            }
        }
        if (targetMode != this.getAnnotationMode()) {
            throw new IllegalStateException("Could not switch annotation mode from " + String.valueOf((Object)currentMode) + " to " + String.valueOf((Object)targetMode));
        }
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public StringFieldValue clone() {
        StringFieldValue copy = (StringFieldValue)super.clone();
        switch (this.getAnnotationMode()) {
            case SIMPLE: {
                copy.simpleAnnotations = new SimpleIndexingAnnotations();
                for (int i = 0; i < this.simpleAnnotations.getCount(); ++i) {
                    copy.simpleAnnotations.add(this.simpleAnnotations.getFrom(i), this.simpleAnnotations.getLength(i), this.simpleAnnotations.getTerm(i));
                }
                copy.spanTrees = null;
                break;
            }
            case FULL: {
                copy.spanTrees = new HashMap<String, SpanTree>(this.spanTrees.size());
                for (Map.Entry<String, SpanTree> entry : this.spanTrees.entrySet()) {
                    copy.spanTrees.put(entry.getKey(), new SpanTree(entry.getValue()));
                }
                copy.simpleAnnotations = null;
                break;
            }
            case NONE: {
                copy.spanTrees = null;
                copy.simpleAnnotations = null;
            }
        }
        return copy;
    }

    @Override
    public void clear() {
        this.value = "";
        this.changeAnnotationMode(AnnotationMode.NONE);
    }

    @Override
    public void assign(Object o) {
        this.changeAnnotationMode(AnnotationMode.NONE);
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof StringFieldValue) {
            StringFieldValue other = (StringFieldValue)o;
            switch (other.getAnnotationMode()) {
                case SIMPLE: {
                    this.simpleAnnotations = other.simpleAnnotations;
                    break;
                }
                case FULL: {
                    this.spanTrees = other.spanTrees;
                    break;
                }
            }
        }
        if (o instanceof String) {
            this.setValue((String)o);
        } else if (o instanceof StringFieldValue || o instanceof NumericFieldValue) {
            this.setValue(o.toString());
        } else {
            throw new IllegalArgumentException("Class " + String.valueOf(o.getClass()) + " not applicable to an " + String.valueOf(this.getClass()) + " instance.");
        }
        this.assertInvariant();
    }

    public Collection<SpanTree> getSpanTrees() {
        if (this.simpleAnnotations != null && this.simpleAnnotations.getCount() > 0) {
            this.changeAnnotationMode(AnnotationMode.FULL);
        }
        if (this.spanTrees == null) {
            return List.of();
        }
        return List.copyOf(this.spanTrees.values());
    }

    public final Map<String, SpanTree> getSpanTreeMap() {
        return this.spanTrees;
    }

    public SpanTree getSpanTree(String name) {
        if (this.getAnnotationMode() == AnnotationMode.SIMPLE && "linguistics".equals(name)) {
            this.changeAnnotationMode(AnnotationMode.FULL);
        }
        return this.spanTrees != null ? this.spanTrees.get(name) : null;
    }

    public boolean hasSpanTree(String name) {
        if (this.simpleAnnotations != null && "linguistics".equals(name)) {
            return true;
        }
        return this.spanTrees != null && this.spanTrees.containsKey(name);
    }

    public SpanTree setSpanTree(SpanTree spanTree) {
        this.changeAnnotationMode(AnnotationMode.FULL);
        if (this.spanTrees.containsKey(spanTree.getName())) {
            throw new IllegalArgumentException("Span tree " + spanTree.getName() + " already exists.");
        }
        this.spanTrees.put(spanTree.getName(), spanTree);
        spanTree.setStringFieldValue(this);
        return spanTree;
    }

    public SpanTree removeSpanTree(String name) {
        if (this.simpleAnnotations != null && "linguistics".equals(name)) {
            SpanTree tree = this.simpleAnnotations.toSpanTree(name);
            this.simpleAnnotations = null;
            return tree;
        }
        if (this.spanTrees == null) {
            return null;
        }
        SpanTree tree = this.spanTrees.remove(name);
        if (tree != null) {
            tree.setStringFieldValue(null);
        }
        return tree;
    }

    public SimpleIndexingAnnotations createSimpleAnnotations() {
        if (!SimpleIndexingAnnotations.isEnabled()) {
            return null;
        }
        if (this.getAnnotationMode() == AnnotationMode.FULL) {
            return null;
        }
        return new SimpleIndexingAnnotations();
    }

    public SimpleIndexingAnnotations getSimpleAnnotations() {
        return this.simpleAnnotations;
    }

    public void setSimpleAnnotations(SimpleIndexingAnnotations simple) {
        this.changeAnnotationMode(AnnotationMode.NONE);
        this.simpleAnnotations = simple;
        this.assertInvariant();
    }

    public String getString() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printStringXml(this, xml);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringFieldValue)) {
            return false;
        }
        StringFieldValue that = (StringFieldValue)o;
        if (!super.equals(o)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        AnnotationMode thisMode = this.getAnnotationMode();
        AnnotationMode thatMode = that.getAnnotationMode();
        if (thisMode == AnnotationMode.NONE && thatMode == AnnotationMode.NONE) {
            return true;
        }
        if (thisMode == AnnotationMode.SIMPLE && thatMode == AnnotationMode.SIMPLE) {
            return Objects.equals(this.simpleAnnotations, that.simpleAnnotations);
        }
        if (thisMode == AnnotationMode.FULL && thatMode == AnnotationMode.FULL) {
            return Objects.equals(this.spanTrees, that.spanTrees);
        }
        return false;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : super.hashCode();
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        AnnotationMode thatMode;
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        StringFieldValue otherValue = (StringFieldValue)fieldValue;
        comp = this.value.compareTo(otherValue.value);
        if (comp != 0) {
            return comp;
        }
        AnnotationMode thisMode = this.getAnnotationMode();
        comp = thisMode.compareTo(thatMode = otherValue.getAnnotationMode());
        if (comp != 0) {
            return comp;
        }
        switch (thisMode) {
            case NONE: {
                return 0;
            }
            case SIMPLE: {
                return this.compareSimpleAnnotations(otherValue);
            }
            case FULL: {
                if (this.spanTrees == null) {
                    return otherValue.spanTrees == null ? 0 : -1;
                }
                if (otherValue.spanTrees == null) {
                    return 1;
                }
                comp = CollectionComparator.compare(this.spanTrees.keySet(), otherValue.spanTrees.keySet());
                if (comp != 0) {
                    return comp;
                }
                return CollectionComparator.compare(this.spanTrees.values(), otherValue.spanTrees.values());
            }
        }
        return 0;
    }

    private int compareSimpleAnnotations(StringFieldValue other) {
        if (this.simpleAnnotations == null) {
            return other.simpleAnnotations == null ? 0 : -1;
        }
        if (other.simpleAnnotations == null) {
            return 1;
        }
        int comp = Integer.compare(this.simpleAnnotations.getCount(), other.simpleAnnotations.getCount());
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.simpleAnnotations.getCount(); ++i) {
            comp = Integer.compare(this.simpleAnnotations.getFrom(i), other.simpleAnnotations.getFrom(i));
            if (comp != 0) {
                return comp;
            }
            comp = Integer.compare(this.simpleAnnotations.getLength(i), other.simpleAnnotations.getLength(i));
            if (comp != 0) {
                return comp;
            }
            String thisTerm = this.simpleAnnotations.getTerm(i);
            String otherTerm = other.simpleAnnotations.getTerm(i);
            if (thisTerm == null) {
                comp = otherTerm == null ? 0 : -1;
            } else {
                int n = comp = otherTerm == null ? 1 : thisTerm.compareTo(otherTerm);
            }
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public void setUnChecked(String s) {
        this.value = s;
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new StringFieldValue();
        }

        @Override
        public FieldValue create(String value) {
            return new StringFieldValue(value);
        }
    }

    private static enum AnnotationMode {
        NONE,
        SIMPLE,
        FULL;

    }
}

