/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation.internal;

import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.StringFieldValue;
import java.util.Objects;
import java.util.logging.Logger;

public final class SimpleIndexingAnnotations {
    private static final Logger log = Logger.getLogger(SimpleIndexingAnnotations.class.getName());
    private static volatile boolean enabled = false;
    private int[] positions = new int[32];
    private String[] terms = new String[16];
    private int count = 0;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean value) {
        log.info("SimpleIndexingAnnotations enabled? " + enabled + " -> " + value);
        enabled = value;
    }

    public void add(int from, int length, String term) {
        this.ensureCapacity();
        this.positions[this.count * 2] = from;
        this.positions[this.count * 2 + 1] = length;
        this.terms[this.count] = term;
        ++this.count;
    }

    private void ensureCapacity() {
        if (this.count * 2 >= this.positions.length) {
            int[] newPos = new int[this.positions.length * 2];
            String[] newTerms = new String[this.terms.length * 2];
            System.arraycopy(this.positions, 0, newPos, 0, this.count * 2);
            System.arraycopy(this.terms, 0, newTerms, 0, this.count);
            this.positions = newPos;
            this.terms = newTerms;
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getFrom(int idx) {
        return this.positions[idx * 2];
    }

    public int getLength(int idx) {
        return this.positions[idx * 2 + 1];
    }

    public String getTerm(int idx) {
        return this.terms[idx];
    }

    public SpanTree toSpanTree(String name) {
        SpanTree tree = new SpanTree(name);
        Span currentSpan = null;
        int currentFrom = -1;
        int currentLength = -1;
        for (int i = 0; i < this.count; ++i) {
            String term;
            int from = this.getFrom(i);
            int length = this.getLength(i);
            if (from != currentFrom || length != currentLength) {
                currentSpan = tree.spanList().span(from, length);
                currentFrom = from;
                currentLength = length;
            }
            if ((term = this.getTerm(i)) != null) {
                tree.annotate((SpanNode)currentSpan, new Annotation(AnnotationTypes.TERM, new StringFieldValue(term)));
                continue;
            }
            tree.annotate((SpanNode)currentSpan, new Annotation(AnnotationTypes.TERM));
        }
        return tree;
    }

    public String toString() {
        return "SimpleIndexingAnnotations with " + this.count + " TERM annotations";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleIndexingAnnotations)) {
            return false;
        }
        SimpleIndexingAnnotations that = (SimpleIndexingAnnotations)o;
        if (this.count != that.count) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.positions[i * 2] != that.positions[i * 2] || this.positions[i * 2 + 1] != that.positions[i * 2 + 1]) {
                return false;
            }
            if (Objects.equals(this.terms[i], that.terms[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.count;
        for (int i = 0; i < this.count; ++i) {
            result = 31 * result + this.positions[i * 2];
            result = 31 * result + this.positions[i * 2 + 1];
            result = 31 * result + Objects.hashCode(this.terms[i]);
        }
        return result;
    }
}

