/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Objects;

public class TensorRemoveUpdate
extends ValueUpdate<TensorFieldValue> {
    private TensorFieldValue tensor;

    public TensorRemoveUpdate(TensorFieldValue value) {
        super(ValueUpdate.ValueUpdateClassID.TENSORREMOVE);
        this.tensor = value;
        if (!this.tensor.getTensor().isPresent()) {
            throw new IllegalArgumentException("Tensor must be present in remove update");
        }
        this.verifyCompatibleType(this.tensor.getTensorType().get());
    }

    public void verifyCompatibleType(TensorType originalType) {
        TensorType sparseType = TensorRemoveUpdate.extractSparseDimensions(originalType);
        TensorType thisType = this.tensor.getTensorType().get();
        for (TensorType.Dimension dim : thisType.dimensions()) {
            if (!sparseType.dimension(dim.name()).isEmpty()) continue;
            throw new IllegalArgumentException("Unexpected type '" + String.valueOf(thisType) + "' in remove update. Expected dimensions to be a subset of '" + String.valueOf(sparseType) + "'");
        }
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            throw new UnsupportedOperationException("Expected tensor type, got " + fieldType.getName() + ".");
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this);
    }

    @Override
    public FieldValue applyTo(FieldValue oldValue) {
        if (!(oldValue instanceof TensorFieldValue)) {
            throw new IllegalStateException("Cannot use tensor remove update on non-tensor datatype " + oldValue.getClass().getName());
        }
        if (!((TensorFieldValue)oldValue).getTensor().isPresent()) {
            throw new IllegalArgumentException("No existing tensor to apply update to");
        }
        if (!this.tensor.getTensor().isPresent()) {
            return oldValue;
        }
        Tensor old = ((TensorFieldValue)oldValue).getTensor().get();
        Tensor update = this.tensor.getTensor().get();
        Tensor result = old.remove(update.cells().keySet());
        return new TensorFieldValue(result);
    }

    @Override
    public TensorFieldValue getValue() {
        return this.tensor;
    }

    @Override
    public void setValue(TensorFieldValue value) {
        this.tensor = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TensorRemoveUpdate that = (TensorRemoveUpdate)o;
        return this.tensor.equals(that.tensor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tensor);
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.tensor);
    }

    public static TensorType extractSparseDimensions(TensorType type) {
        TensorType.Builder builder = new TensorType.Builder(type.valueType());
        type.dimensions().stream().filter(dim -> !dim.isIndexed()).forEach(dim -> builder.mapped(dim.name()));
        return builder.build();
    }
}

