/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.DummySpanNode;
import com.yahoo.document.annotation.SerialIterator;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanNodeParent;
import com.yahoo.document.serialization.SpanNodeReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class AlternateSpanList
extends SpanList {
    public static final byte ID = 4;
    private final List<Children> childTrees = new LinkedList<Children>();
    private static final Comparator<Children> childComparator = new ProbabilityComparator();

    public AlternateSpanList() {
        super((List<SpanNode>)null);
        this.ensureAtLeastOneSubTree();
    }

    public AlternateSpanList(AlternateSpanList otherSpanList) {
        super((List<SpanNode>)null);
        for (Children otherSubtree : otherSpanList.childTrees) {
            Children children = new Children(this);
            for (SpanNode otherNode : otherSubtree.children()) {
                if (otherNode instanceof Span) {
                    children.add(new Span((Span)otherNode));
                    continue;
                }
                if (otherNode instanceof AlternateSpanList) {
                    children.add(new AlternateSpanList((AlternateSpanList)otherNode));
                    continue;
                }
                if (otherNode instanceof SpanList) {
                    children.add(new SpanList((SpanList)otherNode));
                    continue;
                }
                if (otherNode instanceof DummySpanNode) {
                    children.add(otherNode);
                    continue;
                }
                throw new IllegalStateException("Cannot create copy of " + String.valueOf(otherNode) + " with class " + String.valueOf(otherNode == null ? "null" : otherNode.getClass()));
            }
            this.childTrees.add(children);
        }
    }

    public AlternateSpanList(SpanNodeReader reader) {
        this();
        reader.read(this);
    }

    private void ensureAtLeastOneSubTree() {
        if (this.childTrees.isEmpty()) {
            this.childTrees.add(new Children(this.getParent()));
        }
    }

    @Override
    public AlternateSpanList add(SpanNode node) {
        return this.add(0, node);
    }

    public void sortSubTreesByProbability() {
        this.resetCachedFromAndTo();
        Collections.sort(this.childTrees, childComparator);
    }

    @Override
    protected List<SpanNode> children() {
        return this.children(0);
    }

    public int getNumSubTrees() {
        return this.childTrees.size();
    }

    @Override
    public void clearChildren() {
        for (Children c : this.childTrees) {
            c.clearChildren();
        }
    }

    public void clearChildren(int i) {
        Children c = this.childTrees.get(i);
        if (c != null) {
            c.clearChildren();
        }
    }

    @Override
    public void sortChildren() {
        for (Children children : this.childTrees) {
            Collections.sort(children.children());
        }
    }

    public void sortChildren(int i) {
        Children children = this.childTrees.get(i);
        Collections.sort(children.children());
    }

    @Override
    public void sortChildrenRecursive() {
        for (Children children : this.childTrees) {
            for (SpanNode node : children.children()) {
                if (!(node instanceof SpanList)) continue;
                ((SpanList)node).sortChildrenRecursive();
            }
            Collections.sort(children.children());
        }
    }

    public void sortChildrenRecursive(int i) {
        Children children = this.childTrees.get(i);
        for (SpanNode node : children.children()) {
            if (!(node instanceof SpanList)) continue;
            ((SpanList)node).sortChildrenRecursive();
        }
        Collections.sort(children.children());
    }

    public void move(int i, SpanNode node, SpanList target) {
        boolean removed = this.children(i).remove(node);
        if (!removed) {
            throw new IllegalArgumentException("Node " + String.valueOf(node) + " is not a child of this SpanList, cannot move.");
        }
        node.setParent(null);
        this.resetCachedFromAndTo();
        target.add(node);
    }

    public void move(int i, int nodeNum, SpanList target) {
        SpanNode node = this.children(i).remove(nodeNum);
        if (node != null) {
            node.setParent(null);
            this.resetCachedFromAndTo();
            target.add(node);
        }
    }

    public void move(int i, SpanNode node, AlternateSpanList target, int targetSubTree) {
        if (targetSubTree < 0 || targetSubTree >= target.getNumSubTrees()) {
            throw new IndexOutOfBoundsException(String.valueOf(target) + " has no subtree at index " + targetSubTree);
        }
        boolean removed = this.children(i).remove(node);
        if (!removed) {
            throw new IllegalArgumentException("Node " + String.valueOf(node) + " is not a child of this SpanList, cannot move.");
        }
        node.setParent(null);
        this.resetCachedFromAndTo();
        target.add(targetSubTree, node);
    }

    public void move(int i, int nodeNum, AlternateSpanList target, int targetSubTree) {
        if (targetSubTree < 0 || targetSubTree >= target.getNumSubTrees()) {
            throw new IndexOutOfBoundsException(String.valueOf(target) + " has no subtree at index " + targetSubTree);
        }
        SpanNode node = this.children(i).remove(nodeNum);
        if (node != null) {
            node.setParent(null);
            this.resetCachedFromAndTo();
            target.add(targetSubTree, node);
        }
    }

    @Override
    public ListIterator<SpanNode> childIterator() {
        ArrayList<ListIterator<SpanNode>> childIterators = new ArrayList<ListIterator<SpanNode>>();
        for (Children ch : this.childTrees) {
            childIterators.add(ch.childIterator());
        }
        return new SerialIterator(childIterators);
    }

    @Override
    public ListIterator<SpanNode> childIteratorRecursive() {
        ArrayList<ListIterator<SpanNode>> childIterators = new ArrayList<ListIterator<SpanNode>>();
        for (Children ch : this.childTrees) {
            childIterators.add(ch.childIteratorRecursive());
        }
        return new SerialIterator(childIterators);
    }

    public ListIterator<SpanNode> childIterator(int i) {
        return this.childTrees.get(i).childIterator();
    }

    public ListIterator<SpanNode> childIteratorRecursive(int i) {
        return this.childTrees.get(i).childIteratorRecursive();
    }

    public int numChildren(int i) {
        return this.children(i).size();
    }

    protected List<SpanNode> children(int i) {
        return this.childTrees.get(i).children();
    }

    @Override
    void setParent(SpanNodeParent parent) {
        super.setParent(parent);
        for (Children ch : this.childTrees) {
            ch.setParent(parent);
        }
    }

    public boolean addChildren(List<SpanNode> subtree, double probability) {
        Children childTree = new Children(this.getParent(), subtree, probability);
        this.resetCachedFromAndTo();
        return this.childTrees.add(childTree);
    }

    public void addChildren(int i, List<SpanNode> subtree, double probability) {
        Children childTree = new Children(this.getParent(), subtree, probability);
        this.resetCachedFromAndTo();
        this.childTrees.add(i, childTree);
    }

    public List<SpanNode> removeChildren(int i) {
        Children retval = this.childTrees.remove(i);
        this.ensureAtLeastOneSubTree();
        this.resetCachedFromAndTo();
        if (retval != null) {
            retval.setInvalid();
            retval.setParent(null);
            for (SpanNode node : retval.children()) {
                node.setParent(null);
            }
            return retval.children();
        }
        return null;
    }

    public void removeChildren() {
        for (Children ch : this.childTrees) {
            ch.setInvalid();
            ch.setParent(null);
            ch.clearChildren();
        }
        this.childTrees.clear();
        this.resetCachedFromAndTo();
        this.ensureAtLeastOneSubTree();
    }

    @Override
    void setInvalid() {
        super.setInvalid();
        for (Children ch : this.childTrees) {
            ch.setInvalid();
        }
    }

    public List<SpanNode> setChildren(int i, List<SpanNode> subtree, double probability) {
        this.resetCachedFromAndTo();
        if (this.childTrees.size() == 1 && i == 0) {
            Children sub = new Children(this.getParent(), subtree, probability);
            Children retval = this.childTrees.set(i, sub);
            if (retval == null) {
                return null;
            }
            retval.setParent(null);
            for (SpanNode node : retval.children()) {
                node.setParent(null);
            }
            return retval.children();
        }
        List<SpanNode> retval = this.removeChildren(i);
        this.addChildren(i, subtree, probability);
        return retval;
    }

    public int getFrom(int i) {
        return this.childTrees.get(i).getFrom();
    }

    public int getTo(int i) {
        return this.childTrees.get(i).getTo();
    }

    public int getLength(int i) {
        return this.getTo(i) - this.getFrom(i);
    }

    public CharSequence getText(int i, CharSequence text) {
        if (this.children(i).isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        List<SpanNode> ch = this.children(i);
        for (SpanNode node : ch) {
            CharSequence childText = node.getText(text);
            if (childText == null) continue;
            str.append(node.getText(text));
        }
        return str;
    }

    public double getProbability(int i) {
        return this.childTrees.get(i).getProbability();
    }

    public void setProbability(int i, double probability) {
        this.childTrees.get(i).setProbability(probability);
    }

    public void normalizeProbabilities() {
        double sum = 0.0;
        for (Children c : this.childTrees) {
            sum += c.getProbability();
        }
        double coeff = 1.0 / sum;
        for (Children childTree : this.childTrees) {
            double newProb = childTree.getProbability() * coeff;
            childTree.setProbability(newProb);
        }
    }

    public AlternateSpanList add(int i, SpanNode node) {
        this.checkValidity(node, this.children(i));
        node.setParent(this);
        this.children(i).add(node);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlternateSpanList)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlternateSpanList that = (AlternateSpanList)o;
        return this.childTrees.equals(that.childTrees);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.childTrees.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "AlternateSpanList, num subtrees=" + this.getNumSubTrees();
    }

    private class Children
    extends SpanList {
        private double probability;

        private Children(SpanNodeParent parent) {
            this.probability = 1.0;
            this.setParent(parent);
        }

        private Children(SpanNodeParent parent, List<SpanNode> children, double probability) {
            super(children);
            this.probability = 1.0;
            this.setParent(parent);
            if (children != null) {
                for (SpanNode node : children) {
                    node.setParent(AlternateSpanList.this);
                }
            }
            this.probability = probability;
        }

        public double getProbability() {
            return this.probability;
        }

        public void setProbability(double probability) {
            this.probability = probability;
        }
    }

    private static class ProbabilityComparator
    implements Comparator<Children> {
        private ProbabilityComparator() {
        }

        @Override
        public int compare(Children o1, Children o2) {
            return Double.compare(o2.probability, o1.probability);
        }
    }
}

