/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.fieldpathupdate;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentCalculator;
import com.yahoo.document.DocumentType;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.VespaDocumentSerializer6;
import java.util.HashMap;
import java.util.Map;

public class AssignFieldPathUpdate
extends FieldPathUpdate {
    FieldValue fieldValue = null;
    String expression = null;
    boolean createMissingPath = true;
    boolean removeIfZero = false;
    public static final int ARITHMETIC_EXPRESSION = 1;
    public static final int REMOVE_IF_ZERO = 2;
    public static final int CREATE_MISSING_PATH = 4;

    public AssignFieldPathUpdate(DocumentType type, String fieldPath, String whereClause, FieldValue newValue) {
        super(FieldPathUpdate.Type.ASSIGN, type, fieldPath, whereClause);
        this.setNewValue(newValue);
    }

    public AssignFieldPathUpdate(DocumentType type, String fieldPath, FieldValue newValue) {
        super(FieldPathUpdate.Type.ASSIGN, type, fieldPath, null);
        this.setNewValue(newValue);
    }

    public AssignFieldPathUpdate(DocumentType type, String fieldPath, String whereClause, String expression) {
        super(FieldPathUpdate.Type.ASSIGN, type, fieldPath, whereClause);
        this.setExpression(expression);
    }

    public AssignFieldPathUpdate(DocumentType type, DocumentUpdateReader reader) {
        super(FieldPathUpdate.Type.ASSIGN, type, reader);
        reader.read(this);
    }

    public AssignFieldPathUpdate(DocumentType type, String fieldPath) {
        super(FieldPathUpdate.Type.ASSIGN, type, fieldPath, null);
    }

    public void setNewValue(FieldValue value) {
        this.fieldValue = value;
        this.expression = null;
    }

    public FieldValue getNewValue() {
        return this.fieldValue;
    }

    public void setExpression(String value) {
        this.expression = value;
        this.fieldValue = null;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setRemoveIfZero(boolean removeIfZero) {
        this.removeIfZero = removeIfZero;
    }

    public void setCreateMissingPath(boolean createMissingPath) {
        this.createMissingPath = createMissingPath;
    }

    public boolean isArithmetic() {
        return this.expression != null;
    }

    @Override
    FieldPathIteratorHandler getIteratorHandler(Document doc) {
        if (this.expression != null) {
            try {
                return new MathAssignIteratorHandler(this.expression, doc, this.removeIfZero, this.createMissingPath);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return new SimpleAssignIteratorHandler(this.fieldValue, this.removeIfZero, this.createMissingPath);
    }

    @Override
    public void serialize(VespaDocumentSerializer6 data) {
        data.write(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AssignFieldPathUpdate that = (AssignFieldPathUpdate)o;
        if (this.createMissingPath != that.createMissingPath) {
            return false;
        }
        if (this.removeIfZero != that.removeIfZero) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        return !(this.fieldValue != null ? !this.fieldValue.equals(that.fieldValue) : that.fieldValue != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fieldValue != null ? this.fieldValue.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.createMissingPath ? 1 : 0);
        result = 31 * result + (this.removeIfZero ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Assign: " + super.toString() + " : " + (this.isArithmetic() ? this.getExpression() : this.getNewValue().toString());
    }

    public boolean getCreateMissingPath() {
        return this.createMissingPath;
    }

    public boolean getRemoveIfZero() {
        return this.removeIfZero;
    }

    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    class MathAssignIteratorHandler
    extends FieldPathIteratorHandler {
        DocumentCalculator calc;
        Document doc;
        boolean removeIfZero;
        boolean createMissingPath;

        MathAssignIteratorHandler(String expression, Document doc, boolean removeIfZero, boolean createMissingPath) throws ParseException {
            this.calc = new DocumentCalculator(expression);
            this.doc = doc;
            this.removeIfZero = removeIfZero;
            this.createMissingPath = createMissingPath;
        }

        @Override
        public FieldPathIteratorHandler.ModificationStatus doModify(FieldValue fv) {
            if (fv instanceof NumericFieldValue) {
                HashMap<String, Object> vars = new HashMap<String, Object>();
                for (Map.Entry entry : this.getVariables().entrySet()) {
                    if (((FieldPathIteratorHandler.IndexValue)entry.getValue()).getKey() != null && ((FieldPathIteratorHandler.IndexValue)entry.getValue()).getKey() instanceof NumericFieldValue) {
                        vars.put((String)entry.getKey(), ((NumericFieldValue)((FieldPathIteratorHandler.IndexValue)entry.getValue()).getKey()).getNumber());
                        continue;
                    }
                    vars.put((String)entry.getKey(), ((FieldPathIteratorHandler.IndexValue)entry.getValue()).getIndex());
                }
                vars.put("value", ((NumericFieldValue)fv).getNumber());
                try {
                    Number d = this.calc.evaluate(this.doc, vars);
                    if (this.removeIfZero && d.longValue() == 0L) {
                        return FieldPathIteratorHandler.ModificationStatus.REMOVED;
                    }
                    fv.assign(this.calc.evaluate(this.doc, vars));
                }
                catch (IllegalArgumentException e) {
                    return FieldPathIteratorHandler.ModificationStatus.NOT_MODIFIED;
                }
            } else {
                throw new IllegalArgumentException("Trying to perform arithmetic on " + String.valueOf(fv) + " of type " + String.valueOf(fv.getDataType()));
            }
            return FieldPathIteratorHandler.ModificationStatus.MODIFIED;
        }

        @Override
        public boolean createMissingPath() {
            return this.createMissingPath;
        }

        @Override
        public boolean onComplex(FieldValue fv) {
            return false;
        }
    }

    class SimpleAssignIteratorHandler
    extends FieldPathIteratorHandler {
        FieldValue newValue;
        boolean removeIfZero;
        boolean createMissingPath;

        SimpleAssignIteratorHandler(FieldValue newValue, boolean removeIfZero, boolean createMissingPath) {
            this.newValue = newValue;
            this.removeIfZero = removeIfZero;
            this.createMissingPath = createMissingPath;
        }

        @Override
        public FieldPathIteratorHandler.ModificationStatus doModify(FieldValue fv) {
            if (!fv.getDataType().equals(this.newValue.getDataType())) {
                throw new IllegalArgumentException("Trying to assign " + String.valueOf(this.newValue) + " of type " + String.valueOf(this.newValue.getDataType()) + " to an instance of " + String.valueOf(fv.getDataType()));
            }
            if (this.removeIfZero && this.newValue instanceof NumericFieldValue && ((NumericFieldValue)this.newValue).getNumber().longValue() == 0L) {
                return FieldPathIteratorHandler.ModificationStatus.REMOVED;
            }
            fv.assign(this.newValue);
            return FieldPathIteratorHandler.ModificationStatus.MODIFIED;
        }

        @Override
        public boolean createMissingPath() {
            return this.createMissingPath;
        }

        @Override
        public boolean onComplex(FieldValue fv) {
            return false;
        }
    }
}

