/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.fieldpathupdate;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.VespaDocumentSerializer6;

public class AddFieldPathUpdate
extends FieldPathUpdate {
    IteratorHandler handler;

    public AddFieldPathUpdate(DocumentType type, String fieldPath, String whereClause, Array newValues) {
        super(FieldPathUpdate.Type.ADD, type, fieldPath, whereClause);
        this.setNewValues(newValues);
    }

    public AddFieldPathUpdate(DocumentType type, String fieldPath, Array newValues) {
        super(FieldPathUpdate.Type.ADD, type, fieldPath, null);
        this.setNewValues(newValues);
    }

    public AddFieldPathUpdate(DocumentType type, DocumentUpdateReader reader) {
        super(FieldPathUpdate.Type.ADD, type, reader);
        reader.read(this);
    }

    public AddFieldPathUpdate(DocumentType type, String fieldPath) {
        super(FieldPathUpdate.Type.ADD, type, fieldPath, null);
    }

    public void setNewValues(Array value) {
        this.handler = new IteratorHandler(value);
    }

    public Array getNewValues() {
        return this.handler.getNewValues();
    }

    @Override
    public FieldPathIteratorHandler getIteratorHandler(Document doc) {
        return this.handler;
    }

    @Override
    public void serialize(VespaDocumentSerializer6 data) {
        data.write(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddFieldPathUpdate that = (AddFieldPathUpdate)o;
        return this.handler.equals(that.handler);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.handler.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Add: " + super.toString() + " : " + String.valueOf(this.handler.getNewValues());
    }

    class IteratorHandler
    extends FieldPathIteratorHandler {
        Array newValues;

        IteratorHandler(Array newValues) {
            this.newValues = newValues;
        }

        @Override
        public FieldPathIteratorHandler.ModificationStatus doModify(FieldValue fv) {
            for (Object newValue : this.newValues.getValues()) {
                ((CollectionFieldValue)fv).add((FieldValue)newValue);
            }
            return FieldPathIteratorHandler.ModificationStatus.MODIFIED;
        }

        @Override
        public boolean createMissingPath() {
            return true;
        }

        @Override
        public boolean onComplex(FieldValue fv) {
            return false;
        }

        public Array getNewValues() {
            return this.newValues;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IteratorHandler that = (IteratorHandler)o;
            return this.newValues.equals(that.newValues);
        }

        public int hashCode() {
            return this.newValues.hashCode();
        }
    }
}

