/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldUpdate {
    protected Field field;
    protected List<ValueUpdate> valueUpdates = new ArrayList<ValueUpdate>();
    private DocumentType documentType = null;

    FieldUpdate(Field field) {
        this.field = field;
    }

    FieldUpdate(Field field, ValueUpdate valueUpd) {
        this(field);
        this.addValueUpdate(valueUpd);
    }

    FieldUpdate(Field field, List<ValueUpdate> valueUpdates) {
        this(field);
        this.addValueUpdates(valueUpdates);
    }

    public FieldUpdate(DocumentUpdateReader reader, DocumentType type) {
        this.documentType = type;
        reader.read(this);
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public FieldUpdate applyTo(Document doc) {
        for (ValueUpdate vupd : this.valueUpdates) {
            FieldValue newValue;
            boolean existed;
            DataType dataType = this.field.getDataType();
            FieldValue oldValue = doc.getFieldValue(this.field);
            boolean bl = existed = oldValue != null;
            if (!existed) {
                oldValue = dataType.createFieldValue();
            }
            if ((newValue = vupd.applyTo(oldValue)) == null) {
                if (!existed) continue;
                doc.removeFieldValue(this.field);
                continue;
            }
            doc.setFieldValue(this.field, newValue);
        }
        return this;
    }

    public FieldUpdate addValueUpdate(ValueUpdate valueUpdate) {
        valueUpdate.checkCompatibility(this.field.getDataType());
        this.valueUpdates.add(valueUpdate);
        return this;
    }

    public FieldUpdate addValueUpdate(int index, ValueUpdate valueUpdate) {
        valueUpdate.checkCompatibility(this.field.getDataType());
        this.valueUpdates.add(index, valueUpdate);
        return this;
    }

    public FieldUpdate addValueUpdates(List<ValueUpdate> valueUpdates) {
        for (ValueUpdate vupd : valueUpdates) {
            this.addValueUpdate(vupd);
        }
        return this;
    }

    public ValueUpdate removeValueUpdate(int index) {
        return this.valueUpdates.remove(index);
    }

    public ValueUpdate setValueUpdate(int index, ValueUpdate update) {
        return this.valueUpdates.set(index, update);
    }

    public int size() {
        return this.valueUpdates.size();
    }

    public void clearValueUpdates() {
        this.valueUpdates.clear();
    }

    public ValueUpdate getValueUpdate(int index) {
        return this.valueUpdates.get(index);
    }

    public List<ValueUpdate> getValueUpdates() {
        return Collections.unmodifiableList(this.valueUpdates);
    }

    public List<ValueUpdate> getValueUpdates(ValueUpdate.ValueUpdateClassID classID) {
        ArrayList<ValueUpdate> updateList = new ArrayList<ValueUpdate>();
        for (ValueUpdate vupd : this.valueUpdates) {
            if (vupd.getValueUpdateClassID() != classID) continue;
            updateList.add(vupd);
        }
        return updateList;
    }

    public boolean hasValueUpdate(ValueUpdate.ValueUpdateClassID classID) {
        for (ValueUpdate vupd : this.valueUpdates) {
            if (vupd.getValueUpdateClassID() != classID) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.valueUpdates.isEmpty();
    }

    public void addAll(FieldUpdate update) {
        if (update == null) {
            return;
        }
        if (!this.field.equals(update.field)) {
            throw new IllegalArgumentException("Expected " + String.valueOf(this.field) + ", got " + String.valueOf(update.field) + ".");
        }
        this.addValueUpdates(update.valueUpdates);
    }

    public final void serialize(GrowableByteBuffer buf) {
        this.serialize(DocumentSerializerFactory.create6(buf));
    }

    public void serialize(DocumentUpdateWriter data) {
        data.write(this);
    }

    public boolean equals(Object o) {
        return o instanceof FieldUpdate && this.field.equals(((FieldUpdate)o).field) && this.valueUpdates.equals(((FieldUpdate)o).valueUpdates);
    }

    public int hashCode() {
        return this.field.getId() + this.valueUpdates.hashCode();
    }

    public String toString() {
        return "'" + this.field.getName() + "' " + String.valueOf(this.valueUpdates);
    }

    public static FieldUpdate create(Field field) {
        return new FieldUpdate(field);
    }

    public static FieldUpdate createClearField(Field field) {
        return new FieldUpdate(field, ValueUpdate.createClear());
    }

    public static FieldUpdate createAdd(Field field, FieldValue value) {
        return new FieldUpdate(field, ValueUpdate.createAdd(value));
    }

    public static FieldUpdate createAdd(Field field, FieldValue key, Integer weight) {
        return new FieldUpdate(field, ValueUpdate.createAdd(key, weight));
    }

    public static FieldUpdate createAddAll(Field field, List<? extends FieldValue> values) {
        return new FieldUpdate(field, ValueUpdate.createAddAll(values));
    }

    public static FieldUpdate createAddAll(Field field, WeightedSet<? extends FieldValue> set) {
        return new FieldUpdate(field, ValueUpdate.createAddAll(set));
    }

    public static FieldUpdate createIncrement(Field field, Number increment) {
        return new FieldUpdate(field, ValueUpdate.createIncrement(increment));
    }

    public static FieldUpdate createIncrement(Field field, FieldValue key, Number increment) {
        return new FieldUpdate(field, ValueUpdate.createIncrement(key, increment));
    }

    public static FieldUpdate createDecrement(Field field, Number decrement) {
        return new FieldUpdate(field, ValueUpdate.createDecrement(decrement));
    }

    public static FieldUpdate createDecrement(Field field, FieldValue key, Number decrement) {
        return new FieldUpdate(field, ValueUpdate.createDecrement(key, decrement));
    }

    public static FieldUpdate createMultiply(Field field, Number factor) {
        return new FieldUpdate(field, ValueUpdate.createMultiply(factor));
    }

    public static FieldUpdate createMultiply(Field field, FieldValue key, Number factor) {
        return new FieldUpdate(field, ValueUpdate.createMultiply(key, factor));
    }

    public static FieldUpdate createDivide(Field field, Number divisor) {
        return new FieldUpdate(field, ValueUpdate.createDivide(divisor));
    }

    public static FieldUpdate createDivide(Field field, FieldValue key, Number divisor) {
        return new FieldUpdate(field, ValueUpdate.createDivide(key, divisor));
    }

    public static FieldUpdate createAssign(Field field, FieldValue newValue) {
        return new FieldUpdate(field, ValueUpdate.createAssign(newValue));
    }

    public static FieldUpdate createClear(Field field) {
        return new FieldUpdate(field, ValueUpdate.createClear());
    }

    public static FieldUpdate createMap(Field field, FieldValue value, ValueUpdate update) {
        return new FieldUpdate(field, ValueUpdate.createMap(value, update));
    }

    public static FieldUpdate createRemove(Field field, FieldValue value) {
        return new FieldUpdate(field, ValueUpdate.createRemove(value));
    }

    public static FieldUpdate createRemoveAll(Field field, List<? extends FieldValue> values) {
        return new FieldUpdate(field, ValueUpdate.createRemoveAll(values));
    }

    public static FieldUpdate createRemoveAll(Field field, WeightedSet<? extends FieldValue> values) {
        return new FieldUpdate(field, ValueUpdate.createRemoveAll(values));
    }
}

