/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentId;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.CompositeReader;
import com.yahoo.document.json.readers.TensorReader;
import com.yahoo.document.update.ValueUpdate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SingleValueReader {
    public static final String UPDATE_ASSIGN = "assign";
    public static final String UPDATE_INCREMENT = "increment";
    public static final String UPDATE_DECREMENT = "decrement";
    public static final String UPDATE_MULTIPLY = "multiply";
    public static final String UPDATE_DIVIDE = "divide";
    public static final Map<String, String> UPDATE_OPERATION_TO_ARITHMETIC_SIGN = new HashMap<String, String>();
    public static final Map<String, String> ARITHMETIC_SIGN_TO_UPDATE_OPERATION;
    private static final Pattern arithmeticExpressionPattern;

    public static FieldValue readSingleValue(TokenBuffer buffer, DataType expectedType, boolean ignoreUndefinedFields) {
        if (expectedType instanceof TensorDataType) {
            FieldValue fieldValue = expectedType.createFieldValue();
            TensorReader.fillTensor(buffer, (TensorFieldValue)fieldValue);
            return fieldValue;
        }
        if (buffer.current().isScalarValue()) {
            return SingleValueReader.readAtomic(buffer.currentText(), expectedType);
        }
        FieldValue fieldValue = expectedType.createFieldValue();
        CompositeReader.populateComposite(buffer, fieldValue, ignoreUndefinedFields);
        return fieldValue;
    }

    public static ValueUpdate readSingleUpdate(TokenBuffer buffer, DataType expectedType, String action, boolean ignoreUndefinedFields) {
        return switch (action) {
            case UPDATE_ASSIGN -> {
                if (buffer.current() == JsonToken.VALUE_NULL) {
                    yield ValueUpdate.createClear();
                }
                yield ValueUpdate.createAssign(SingleValueReader.readSingleValue(buffer, expectedType, ignoreUndefinedFields));
            }
            case UPDATE_INCREMENT -> ValueUpdate.createIncrement(Double.valueOf(buffer.currentText()));
            case UPDATE_DECREMENT -> ValueUpdate.createDecrement(Double.valueOf(buffer.currentText()));
            case UPDATE_MULTIPLY -> ValueUpdate.createMultiply(Double.valueOf(buffer.currentText()));
            case UPDATE_DIVIDE -> ValueUpdate.createDivide(Double.valueOf(buffer.currentText()));
            default -> throw new IllegalArgumentException("Operation '" + buffer.currentName() + "' not implemented.");
        };
    }

    public static Matcher matchArithmeticOperation(String expression) {
        return arithmeticExpressionPattern.matcher(expression.trim());
    }

    public static FieldValue readAtomic(String field, DataType expectedType) {
        if (expectedType.equals(PositionDataType.INSTANCE)) {
            return PositionDataType.fromString(field);
        }
        if (expectedType instanceof ReferenceDataType) {
            return SingleValueReader.readReferenceFieldValue(field, expectedType);
        }
        return expectedType.createFieldValue(field);
    }

    private static FieldValue readReferenceFieldValue(String refText, DataType expectedType) {
        FieldValue value = expectedType.createFieldValue();
        if (!refText.isEmpty()) {
            value.assign((Object)new DocumentId(refText));
        }
        return value;
    }

    static {
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_INCREMENT, "+");
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_DECREMENT, "-");
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_MULTIPLY, "*");
        UPDATE_OPERATION_TO_ARITHMETIC_SIGN.put(UPDATE_DIVIDE, "/");
        ARITHMETIC_SIGN_TO_UPDATE_OPERATION = UPDATE_OPERATION_TO_ARITHMETIC_SIGN.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        String validSigns = Pattern.quote(String.join((CharSequence)"", UPDATE_OPERATION_TO_ARITHMETIC_SIGN.values()));
        arithmeticExpressionPattern = Pattern.compile("^\\$\\w+\\s*([" + validSigns + "])\\s*(\\d+(.\\d+)?)$");
    }
}

