/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;

public class AssignValueUpdate
extends ValueUpdate {
    protected FieldValue value;

    public AssignValueUpdate(FieldValue value) {
        super(ValueUpdate.ValueUpdateClassID.ASSIGN);
        this.value = value;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public void setValue(FieldValue value) {
        this.value = value;
    }

    @Override
    public FieldValue applyTo(FieldValue fval) {
        if (this.value == null) {
            return null;
        }
        fval.assign(this.value);
        return fval;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (this.value != null && !this.value.getDataType().equals(fieldType)) {
            throw new IllegalArgumentException("Expected " + fieldType.getName() + ", got " + this.value.getDataType().getName());
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this, superType);
    }

    @Override
    public boolean equals(Object o) {
        boolean baseEquals;
        boolean bl = baseEquals = o instanceof AssignValueUpdate && super.equals(o);
        if (!baseEquals) {
            return false;
        }
        if (this.value == null && ((AssignValueUpdate)o).value == null) {
            return true;
        }
        return this.value != null && this.value.equals(((AssignValueUpdate)o).value);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.value == null ? 0 : this.value.hashCode());
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.value;
    }
}

