/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.simple;

import com.yahoo.document.select.rule.ComparisonNode;
import com.yahoo.document.select.rule.ExpressionNode;
import com.yahoo.document.select.simple.IdSpecParser;
import com.yahoo.document.select.simple.IntegerParser;
import com.yahoo.document.select.simple.OperatorParser;
import com.yahoo.document.select.simple.Parser;
import com.yahoo.document.select.simple.StringParser;

public class SelectionParser
extends Parser {
    private ExpressionNode node;

    public ExpressionNode getNode() {
        return this.node;
    }

    @Override
    public boolean parse(CharSequence s) {
        boolean retval = false;
        IdSpecParser id = new IdSpecParser();
        if (id.parse(s)) {
            OperatorParser op = new OperatorParser();
            if (op.parse(id.getRemaining())) {
                if (id.isUserSpec()) {
                    IntegerParser v = new IntegerParser();
                    if (v.parse(op.getRemaining())) {
                        this.node = new ComparisonNode(id.getId(), op.getOperator(), v.getValue());
                        retval = true;
                    }
                    this.setRemaining(v.getRemaining());
                } else {
                    StringParser v = new StringParser();
                    if (v.parse(op.getRemaining())) {
                        this.node = new ComparisonNode(id.getId(), op.getOperator(), v.getValue());
                        retval = true;
                    }
                    this.setRemaining(v.getRemaining());
                }
            } else {
                this.setRemaining(op.getRemaining());
            }
        } else {
            this.setRemaining(id.getRemaining());
        }
        return retval;
    }
}

