/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public class ByteFieldValue
extends NumericFieldValue {
    public static final int classId = ByteFieldValue.registerClass((int)4106, ByteFieldValue.class);
    private byte value;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public ByteFieldValue() {
        this(0);
    }

    public ByteFieldValue(byte value) {
        this.value = value;
    }

    public ByteFieldValue(Byte value) {
        this.value = value;
    }

    public ByteFieldValue(Integer value) {
        this.value = (byte)value.intValue();
    }

    public ByteFieldValue(String s) {
        this.value = Byte.parseByte(s);
    }

    @Override
    public ByteFieldValue clone() {
        ByteFieldValue val = (ByteFieldValue)super.clone();
        val.value = this.value;
        return val;
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public void clear() {
        this.value = 0;
    }

    @Override
    public void assign(Object o) {
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof Number) {
            this.value = ((Number)o).byteValue();
        } else if (o instanceof NumericFieldValue) {
            this.value = ((NumericFieldValue)o).getNumber().byteValue();
        } else if (o instanceof String || o instanceof StringFieldValue) {
            this.value = Byte.parseByte(o.toString());
        } else {
            throw new IllegalArgumentException("Class " + o.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    public byte getByte() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    public DataType getDataType() {
        return DataType.BYTE;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printByteXml(this, xml);
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteFieldValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteFieldValue that = (ByteFieldValue)o;
        return this.value == that.value;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        ByteFieldValue otherValue = (ByteFieldValue)fieldValue;
        if (this.value < otherValue.value) {
            return -1;
        }
        if (this.value > otherValue.value) {
            return 1;
        }
        return 0;
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new ByteFieldValue();
        }

        @Override
        public FieldValue create(String value) {
            return new ByteFieldValue(value);
        }
    }
}

